% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbmt-plot.r
\name{plot.GBMFit}
\alias{plot.GBMFit}
\title{Marginal plots of fitted gbm objects}
\usage{
\method{plot}{GBMFit}(
  x,
  var_index = 1,
  num_trees = gbm_fit_obj$params$num_trees,
  continuous_resolution = 100,
  grid_levels = NULL,
  return_grid = FALSE,
  type = "link",
  ...
)
}
\arguments{
\item{x}{a \code{GBMFit} object fitted using a call to
\code{\link{gbmt}}}

\item{var_index}{a vector of indices or the names of the variables
to plot. If using indices, the variables are indexed in the same
order that they appear in the initial \code{gbmt} formula.  If
\code{length(var_index)} is between 1 and 3 then \code{plot.GBMFit}
produces the plots. Otherwise, \code{plot.GBMFit} returns only the
grid of evaluation points and their average predictions}

\item{num_trees}{the number of trees used to generate the
plot. Only the first \code{num_trees} trees will be used}

\item{continuous_resolution}{The number of equally space points at
which to evaluate continuous predictors}

\item{grid_levels}{A list containing the points at which to
evaluate each predictor in \code{var_index} (in the same order as
\code{var_index}). For continuous predictors this is usually a
regular sequence of values within the range of the variable. For
categorical predictors, the points are the levels of the
factor. When \code{length(var_index)} is one, the values can be
provided directly, outside a list.  This is NULL by default and
generated automatically from the data, using
\code{continuous_resolution} for continuous predictors. Forcing the
values can be useful to evaluate two models on the same exact range}

\item{return_grid}{if \code{TRUE} then \code{plot.GBMFit} produces no
graphics and only returns the grid of evaluation points and their
average predictions. This is useful for customizing the graphics
for special variable types or for dimensions greater than 3}

\item{type}{the type of prediction to plot on the vertical
axis. See \code{predict_gmt}}

\item{\dots}{other arguments passed to the plot function}
}
\value{
Nothing unless \code{return_grid} is true then
\code{plot.GBMFit} produces no graphics and only returns the grid of
evaluation points and their average predictions.
}
\description{
Plots the marginal effect of the selected variables by
"integrating" out the other variables.
}
\details{
\code{plot.GBMFit} produces low dimensional projections of the
\code{GBMFit} object, see \code{\link{gbmt}}, by integrating out
the variables not included in the \code{var_index} argument. The
function selects a grid of points and uses the weighted tree
traversal method described in Friedman (2001) to do the
integration. Based on the variable types included in the
projection, \code{plot_gbmt} selects an appropriate display
choosing amongst line plots, contour plots, and
\code{\link[lattice]{lattice}} plots. If the default graphics are
not sufficient the user may set \code{return.grid=TRUE}, store the
result of the function, and develop another graphic display more
appropriate to the particular example.
}
\references{
J.H. Friedman (2001). "Greedy Function Approximation: A Gradient
Boosting Machine," Annals of Statistics 29(4).
}
\seealso{
\code{\link{gbmt}}, \code{\link[graphics]{plot}}
}
\keyword{hplot}
