% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm-baseline-hazard.r
\name{baseline_hazard}
\alias{baseline_hazard}
\title{Baseline hazard function}
\usage{
baseline_hazard(surv_times, delta, coxph_preds, eval_times=NULL, smooth=FALSE,
cumulative=TRUE)
}
\arguments{
\item{surv_times}{the survival times - an atomic vector of doubles}

\item{delta}{the censoring indicator - a vector same length as surv_times}

\item{coxph_preds}{the predicted values of the regression model on the log hazard
scale}

\item{eval_times}{values at which the baseline hazard will be evaluated}

\item{smooth}{if \code{TRUE} \code{baseline_hazard} will smooth the estimated
baseline hazard using Friedman's super smoother \code{\link{supsmu}}}

\item{cumulative}{if \code{TRUE} the cumulative survival function will be
computed}
}
\value{
a vector of length equal to the length of surv_times (or of length
\code{eval_times} if \code{eval_times} is not \code{NULL}) containing the baseline
hazard evaluated at t (or at \code{eval_times} if \code{eval_times} is not
\code{NULL}). If \code{cumulative} is set to \code{TRUE} then the returned
vector evaluates the cumulative hazard function at those values.
}
\description{
Computes the Breslow estimator of the baseline hazard function for a
proportional hazard regression model - only for censored survival data.
}
\details{
The proportional hazard model assumes h(t|x)=lambda(t)*exp(f(x)).
\code{\link{gbmt}} can estimate the f(x) component via partial likelihood.
After estimating f(x), \code{baseline_hazard} can compute a nonparametric
estimate of lambda(t).
}
\references{
N. Breslow (1972). "Discussion of `Regression Models and
Life-Tables' by D.R. Cox," Journal of the Royal Statistical Society, Series
B, 34(2):216-217.

N. Breslow (1974). "Covariance analysis of censored survival data,"
Biometrics 30:89-99.
}
\seealso{
\code{\link[survival]{survfit}}, \code{\link{gbmt}}
}
\author{
James Hickey, Greg Ridgeway \email{gregridgeway@gmail.com}
}
\keyword{methods}
\keyword{survival}
