% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pval_correct.R
\name{pval_correct}
\alias{pval_correct}
\title{Calculate p-value corrections}
\usage{
pval_correct(input, alpha = 0.05, nbc = NULL)
}
\arguments{
\item{input}{An object of class 'rrs' from the \code{\link{rrs}} or \code{\link{lotrrs}} function.}

\item{alpha}{Numeric. The two-tailed alpha level for significance threshold (default in \code{\link{rrs}} and \code{\link{lotrrs}} functions is 0.05).}

\item{nbc}{Integer. The number of bins. Similar to \code{nbclass} argument in \code{\link[pgirmess]{correlog}} function. The default is the average number of gridded knots in one-dimension (i.e., x-axis).}
}
\value{
An object of class 'list'. This is a named list with the following components:

\describe{
\item{\code{uncorrected}}{Numeric. Returns the uncorrected p-value.}
\item{\code{correlated}}{Numeric. Returns the correlated Bonferroni corrected p-value.}
\item{\code{uncorrelated}}{Numeric. Returns the uncorrelated Bonferroni corrected p-value.}
}
}
\description{
Internal function to calculate various p-value corrections including a correlated and uncorrelated Bonferroni correction for use within the \code{\link{rrs}} and \code{\link{lotrrs}} function.
}
\details{
This function provides functionality for multiple testing correction in two ways:

\enumerate{
\item Computes a conventional Bonferroni correction ("uncorrelated") by dividing the \code{alpha} level by the number of gridded knots across the estimated surface. The default in the \code{\link[sparr]{risk}} function is a resolution of 128 x 128 or n = 16,384 knots.
\item Computes a correlated Bonferroni correction ("correlated") by taking in account the spatial correlation of the relative risk surface values (if using the \code{rrs} function for a single condition gate) or the ratio of relative risk surfaces values (if using the \code{lotrrs} function for a two condition gate). The \code{alpha} level is divided by the minimum number of knots that are not spatially correlated. The minimum number of knots that are not spatially correlated is computed by counting the knots that are a distance apart that exceeds the minimum distance of non-significant spatial correlation based on a correlogram using the \code{\link[pgirmess]{correlog}} function.
}
}
\keyword{internal}
