
# MATRIX FUNCTIONS


# Compute Matrix Inverse -------------------------------------------------------
matrix_inv <- function(mat) {
  mat_inv <- try_and_be_silent(pracma::pinv(mat))
  if ("try-error" %in% class(mat_inv)) {
    mat_inv <- matrix(NA_real_, nrow = nrow(mat), ncol = ncol(mat))
  }
  return(mat_inv)
}
# ------------------------------------------------------------------------------


# Compute Matrix Inverse Square Root -------------------------------------------
matrix_inv_sqrt <- function(mat) {
  mat_eigen <- try_and_be_silent(base::eigen(mat, symmetric = TRUE))
  if ("try-error" %in% class(mat_eigen)) {
    mat_inv_sqrt <- matrix(NA_real_, nrow = nrow(mat), ncol = ncol(mat))
  } else {
    mat_eigen$values[mat_eigen$values < 1e-6] <- 0
    mat_inv_sqrt <- try_and_be_silent(mat_eigen$vectors %*% pracma::pinv(mat_eigen$vectors %*% diag(sqrt(mat_eigen$values))))
    if ("try-error" %in% class(mat_inv_sqrt)) {
      mat_inv_sqrt <- matrix(NA_real_, nrow = nrow(mat), ncol = ncol(mat))
    }
  }
  return(mat_inv_sqrt)
}
# ------------------------------------------------------------------------------


# Compute Diagonal Matrix Inverse ----------------------------------------------
matrix_diag_inv <- function(mat) {
  mat_inv <- be_silent(diag(1 / diag(mat), nrow = nrow(mat)))
  return(mat_inv)
}
# ------------------------------------------------------------------------------


# Compute Diagonal Matrix Inverse Square Root ----------------------------------
matrix_diag_inv_sqrt <- function(mat) {
  mat_inv_sqrt <- be_silent(diag(1 / sqrt(diag(mat)), nrow = nrow(mat)))
  return(mat_inv_sqrt)
}
# ------------------------------------------------------------------------------


