% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Comparator-generics.R, R/Comparator-methods.R
\docType{methods}
\name{comparators}
\alias{comparators}
\alias{\%starts_with\%}
\alias{\%ends_with\%}
\alias{\%contains\%}
\alias{\%matches\%}
\alias{\%between\%}
\alias{\%in\%}
\alias{\%matches\%,.var,.dimOperand-method}
\alias{\%starts_with\%,.var,.dimOperand-method}
\alias{\%ends_with\%,.var,.dimOperand-method}
\alias{\%contains\%,.var,.dimOperand-method}
\alias{\%between\%,.var,.operand-method}
\alias{\%in\%,.var,.operand-method}
\alias{==,.var,.operand-method}
\alias{!=,.var,.operand-method}
\alias{>,.var,.metOperand-method}
\alias{<,.var,.metOperand-method}
\alias{>=,.var,.metOperand-method}
\alias{<=,.var,.metOperand-method}
\title{Comparison operators}
\usage{
var \%starts_with\% operand

var \%ends_with\% operand

var \%contains\% operand

var \%matches\% operand

var \%between\% operand

x \%in\% table

\S4method{\%matches\%}{.var,.dimOperand}(var, operand)

\S4method{\%starts_with\%}{.var,.dimOperand}(var, operand)

\S4method{\%ends_with\%}{.var,.dimOperand}(var, operand)

\S4method{\%contains\%}{.var,.dimOperand}(var, operand)

\S4method{\%between\%}{.var,.operand}(var, operand)

\S4method{\%in\%}{.var,.operand}(x, table)

\S4method{==}{.var,.operand}(e1, e2)

\S4method{!=}{.var,.operand}(e1, e2)

\S4method{>}{.var,.metOperand}(e1, e2)

\S4method{<}{.var,.metOperand}(e1, e2)

\S4method{>=}{.var,.metOperand}(e1, e2)

\S4method{<=}{.var,.metOperand}(e1, e2)
}
\arguments{
\item{var}{The name of a single Google Analytics dimension or metric, as a
character string or a \code{.var} object generated with \code{\link{Var}}.}

\item{operand}{An operand appropriate to the selected \code{var} and
comparison operator. A vector usually of length-one, or exactly length-two
in the case of \code{\%between\%}, or at least length-two in the case of
\code{\%in\%}. Usually either a character string or numeric value.}

\item{x}{A dimension.}

\item{table}{A vector of possible values within that dimension.}

\item{e1}{A dimension or metric.}

\item{e2}{An operand object of length-one.}
}
\value{
an \code{expr} object.
}
\description{
Binary operators used to define Google Analytics filters and segments.
}
\section{\%starts_with\%}{

A condition where the dimension (LHS) matches values that start with the
character string given by the operand (RHS).
}

\section{\%ends_with\%}{

A condition where the dimension (LHS) matches values that end with the
character string given by the operand (RHS).
}

\section{\%contains\%}{

A condition where the dimension (LHS) matches values that contain the
character string given by the operand (RHS).
}

\section{\%matches\%}{

A condition where the dimension (LHS) matches a regular expression given by
the operand (RHS).
}

\section{\%between\%}{

A condition where the var (LHS) is within the lower and upper bounds
specified by first and second vector value (respectively) of the operand
(RHS).
}

\section{\%in\%}{

A condition where the dimension (LHS) matches one of the values in the vector
specified by the operand (RHS).
}

\section{Equal-to (\code{==})}{

Do the values on the left and right match exactly.
}

\section{Not equal-to (\code{!=})}{

Do the values on the left and right not match.
}

\section{Greater-than (\code{>})}{

Is the value on the left greater than the value on the right.
}

\section{Less-than (\code{<})}{

Is the value on the left less than the value on the right.
}

\section{Greater-than-or-equal-to (\code{>=})}{

Is the value on the left greater than or equal to the value on the right.
}

\section{Less-than-or-equal-to (\code{<=})}{

Is the value on the left less than or equal to the value on the right.
}

\examples{
Expr(~PagePath \%starts_with\% "/products")
Expr(~PagePath \%ends_with\% "/index.html")
Expr(~PagePath \%contains\% "thank-you")
Expr(~PagePath \%matches\% "*.thank[\\\\-_]?you.*")
Expr(~transactionRevenue \%between\% c(200, 500))
Expr(~browser \%in\% c("Chrome", "Firefox"))
Expr(~productName == "apple")
Expr(~bounces == 0)
Expr(~deviceCategory != "tablet")
Expr(~sessionDuration != 0)
Expr(~pageviews > 100)
Expr(~exits < 100)
}
\seealso{
Other comparator functions: \code{\link{Comparator}}
}
\concept{comparator functions}
