% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmPlotSubspaces.R
\name{dmPlotEvaluate}
\alias{dmPlotEvaluate}
\title{Create an image file for an evaluated data source}
\usage{
dmPlotEvaluate(
  evaluateDataSourceFileName,
  level,
  imageFileName,
  title,
  columnIndices,
  plotGenerativeDataParameters = dmPlotGenerativeDataParameters(percent = 10, colour =
    "red"),
  plotEvaluateDataSourceParameters = dmPlotEvaluateDataSourceParameters(colour = "blue")
)
}
\arguments{
\item{evaluateDataSourceFileName}{Name of evaluated data source file'}

\item{level}{Level for subspaces}

\item{imageFileName}{Name of image file}

\item{title}{Title of image}

\item{columnIndices}{Vector of two column indices that are used for the two-dimensional projection.
Indices refer to indices of active columns of data source.}

\item{plotGenerativeDataParameters}{Plot generative data parameters, see dmPlotGenerativeDataParameters().}

\item{plotEvaluateDataSourceParameters}{Plot parameters for evaluated data source, see dmPlotEvaluateDataSourceParameters().}
}
\value{
None
}
\description{
Create an image file containing two-dimensional projections of generative data
and an evaluated data source.
Plot parameters are passed by functions dmPlotGenerativeDataParameters()
and dmPlotEvaluateDataSourceParameters().
Data points are drwan in the order generative data, evaluated data source.
}
\examples{
\dontrun{
dmRead("dm.bin", "gd.bin")
dmRead("dm.bin", "gd.bin")
dmPlotEvaluate("ds.bin",
  0.73,
  "s1d34.png",
  "Subspace of Hierarchical, Categorical Data Model for the Iris Dataset",
  c(3, 4),
  dmPlotGenerativeDataParameters(10),
  dmPlotEvaluateDataSourceParameters())}
}
