% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotope-maneuvers.R
\name{group_birds_by_location}
\alias{group_birds_by_location}
\title{Group bird isotope data by locations}
\usage{
group_birds_by_location(D, feather_isotope_col, location_col,
  iso_pred_col = "iso_pred", iso_sd_col = "iso_sd")
}
\arguments{
\item{D}{the data frame of feather isotope data with the isoscape predictions
extracted for each location, as well, and a column giving general grouping
locations for the birds.}

\item{feather_isotope_col}{the string name of the column holding the feather isotope
data.}

\item{location_col}{the string name of the column holding the locations to be
used for grouping.}

\item{iso_pred_col}{name of the column holding the predicted values from the isoscape. Default
is \code{iso_pred}.}

\item{iso_sd_col}{name of the column holding the standard deviations of the predicted values
from the isoscape. Default is \code{iso_sd_col}.}
}
\description{
This takes as input a data frame of feather isotope data that also has the
isoscape predictions attached to it, just like the data frame returned by
\code{\link{extract_isopredictions}}.  The data frame must have a column
that gives the general location by which you will group birds for the
rescaling function.  The isoscape predictions by default should be in columns named
\code{iso_pred} for the actual prediction, and \code{iso_sd} for the standard deviation,
as produced by \code{\link{extract_isopredictions}}, but those are user configurable,
as well.
}
\details{
This function returns a data frame with columns for the mean and SD of feather/bird values,
(\code{meanH} and \code{sdH}) and the mean predicted isotope value and the mean sd of the predicted
isotope values (\code{meaniso} and \code{sdiso}) for all the samples within each location.  It
also returns the Location column itself and a column \code{cnt} that gives the number of bird/tissue
samples from each location.

This function
throws an error if any of the locations has only 1 sample.  If that is the case, you may consider
merging that sample with another location (or dropping it?).
}
\examples{
# first run the example for extract_isopredictions to get the variable "x"
example("extract_isopredictions")

# If this were run it gives an error because there is only 1 bird at the
# location "Charlevoix"
\dontrun{
group_birds_by_location(x, feather_isotope_col = "Isotope.Value", location_col = "Location")
}


# remove that one bird at Charlevoix and re-run
y <- x \%>\%
  dplyr::filter(Location != "Charlevoix")

# then group birds by location
gbl <- group_birds_by_location(D = y,
                               feather_isotope_col = "Isotope.Value",
                               location_col = "Location")
}

