% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwqs.R
\name{summary.gwqs}
\alias{summary.gwqs}
\alias{summary.gwqsrh}
\alias{print.gwqs}
\alias{print.gwqsrh}
\alias{print.summary.gwqs}
\alias{print.summary.gwqsrh}
\alias{predict.gwqs}
\alias{predict.gwqsrh}
\alias{coef.gwqs}
\alias{coef.gwqsrh}
\alias{vcov.gwqs}
\alias{vcov.gwqsrh}
\alias{fitted.gwqs}
\alias{fitted.gwqsrh}
\alias{residuals.gwqs}
\alias{residuals.gwqsrh}
\title{Methods for gwqs objects}
\usage{
\method{summary}{gwqs}(object, ...)

\method{summary}{gwqsrh}(object, sumtype = c("norm", "perc"), ...)

\method{print}{gwqs}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{print}{gwqsrh}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{print}{summary.gwqs}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{print}{summary.gwqsrh}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{predict}{gwqs}(
  object,
  newdata,
  type = c("link", "response", "prob", "count", "zero", "class", "probs", "terms"),
  ...
)

\method{predict}{gwqsrh}(
  object,
  newdata,
  sumtype = c("norm", "perc"),
  type = c("link", "response", "prob", "count", "zero", "class", "probs", "terms"),
  ...
)

\method{coef}{gwqs}(object, ...)

\method{coef}{gwqsrh}(object, sumtype = c("norm", "perc"), ...)

\method{vcov}{gwqs}(object, model = c("full", "count", "zero"), ...)

\method{vcov}{gwqsrh}(object, model = c("full", "count", "zero"), ...)

\method{fitted}{gwqs}(object, type = c("prob", "response"), ...)

\method{fitted}{gwqsrh}(object, sumtype = c("norm", "perc"), type = c("prob", "response"), ...)

\method{residuals}{gwqs}(
  object,
  type = c("deviance", "pearson", "working", "response", "partial"),
  ...
)

\method{residuals}{gwqsrh}(
  object,
  sumtype = c("norm", "perc"),
  type = c("pearson", "response"),
  ...
)
}
\arguments{
\item{object, x}{An object of class "gwqs" as returned by \code{gwqs}.}

\item{...}{Further arguments to be passed.}

\item{sumtype}{Type of summary statistic to be used: "norm" takes the mean of the estimated parameters on the
validation sets and the 95% CI assuming a normal distribution of the parameters, while "perc" uses the median
as the parameters estimates and the 2.5, 97.5 percentiles as CI. This option is only available for objects of
class \code{gwqsrh}.}

\item{digits}{The number of significant digits to use when printing.}

\item{newdata}{Optionally, a data frame in which to look for variables with which to predict.
If omitted, the original observations are used.}

\item{type}{Character specifying the type of predictions, fitted values or residuals, respectively.
For details see below.}

\item{model}{Character specifying for which component of the model the varance-covariance matrix
should be extracted when zero_infl = TRUE.}
}
\value{
All these methods return the classic output as for the corresponding glm, glm.nb, multinom and
zeroinfl classes. Only the predict method gives a different output made of the following values.

\item{df_pred}{A data.frame containing the dependent varible and the predicted values.}
\item{Q}{The matrix containing the new dataset quantiled variables of the elements included in the mixture.}
\item{qi}{A list of vectors containing the cut points used to determine the quantiled variables.}
\item{wqs}{The vetor containing the wqs index built on the new dataset.}
}
\description{
Methods for extracting information from fitted Weighted Quantile Sum (WQS) regression model objects
of class "gwqs".
}
\details{
A set of standard extractor functions for fitted model objects is available for objects of class "gwqs",
including methods to the generic functions print and summary which print the estimated coefficients
along with some further information. As usual, the summary method returns an object of class
"summary.gwqs" containing the relevant summary statistics which can subsequently be printed using the
associated print method.

The methods for \link[stats]{coef} and \link[stats]{vcov} by default return a single vector of
coefficients (a matrix when family = "multinomial") and their associated covariance matrix, respectively.
By setting the model argument, the estimates for the corresponding model components can be extracted.

Both the \code{fitted} and \link[stats]{predict} methods can compute fitted responses. The latter
sets the default on the scale of the linear predictors; the alternative "response" is on the scale of the
response variable. Thus for a default binomial model the default predictions are of log-odds
(probabilities on logit scale) and type = "response" gives the predicted probabilities. Type can be equal
to "prob", "count" or "zero" when zero_infl = T to estimate the predicted density (i.e., probabilities for
the observed counts), the predicted mean from the count component (without zero inflation) and the
predicted probability for the zero component. Type = "class" allow to predict the dependent variable
categories when family = "multinomial". The "terms" option returns a matrix giving the fitted values of
each term in the model formula on the linear predictor scale.

The \link[stats]{residuals} method allows to extracts model residuals from the objects of class "gwqs".
}
\examples{
toxic_chems = names(wqs_data)[1:34]
set.seed(1234)
rws <- sample(1:500, 150)
results = gwqs(yLBX ~ wqs, mix_name = toxic_chems, data = wqs_data[-rws,], q = 4, validation = 0.6,
               b = 1, b1_pos = TRUE, b1_constr = FALSE, family = gaussian)

# to test the significance of the covariates
summary(results)

# extract regression coefficients
coef(results)

# estimate variance-covariance matrix
vcov(results)

# estimate fitted values
fitted(results)

# estimate regression residuals
residuals(results)

# estimate predicted values on the left part of wqs_data
pred_res <- predict(results, wqs_data[rws,])
pred_res$df_pred

}
\author{
Stefano Renzetti, Paul Curtin, Allan C Just, Ghalib Bello, Chris Gennings
}
