% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpt-pot-gather.R
\name{components_gather}
\alias{components_gather}
\alias{compileCPT}
\alias{parse_cpt,}
\alias{parse_cpt.xtabs,parse_cpt.cptable_class,}
\alias{parse_cpt.default}
\alias{compilePOT}
\alias{parse_cpt}
\title{Compile conditional probability tables / cliques potentials.}
\usage{
compileCPT(x, ..., forceCheck = TRUE)

compilePOT(x, ..., forceCheck = TRUE)

parse_cpt(xi)
}
\arguments{
\item{x}{To \code{compileCPT} x is a list of conditional
probability tables; to \code{compilePOT}, x is a list of clique
potentials.}

\item{...}{Additional arguments; currently not used.}

\item{forceCheck}{Controls if consistency checks of the probability
tables should be made.}

\item{xi}{cpt in some representation}
}
\value{
A list with a class attribute.
}
\description{
Compile conditional probability tables / cliques
potentials as a preprocessing step for creating a graphical
independence network
}
\details{
\preformatted{* `compileCPT` is relevant for turning a collection of
cptable's into an object from which a network can be built. For
example, when specification of a cpt is made with cptable then
the levels of the node is given but not the levels of the
parents. `compileCPT` checks that the levels of variables in
the cpt's are consistent and also that the specifications
define a dag.

* `compilePOT` is not of direct relevance for the
user for the moment. However, the elements of the input should
be arrays which define a chordal undirected graph and the
arrays should, if multiplied, form a valid probability density.
}
}
\examples{

data(chest_cpt)
x <- compileCPT(chest_cpt)
class(x)
grain(x)

## FIXME: compileCPT/compilePOT examples missing.
}
\references{
Søren Højsgaard (2012). Graphical Independence Networks
with the gRain Package for R. Journal of Statistical Software,
46(10), 1-26.  \url{http://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{extractCPT}}, \code{\link{extractPOT}}, \code{\link{extractMARG}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
