% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotTitleTeX3D}
\alias{plotTitleTeX3D}
\title{Draw boxes, axes and other text outside the data using TeX strings.}
\usage{
plotTitleTeX3D(
  main = NULL,
  sub = NULL,
  xlab = NULL,
  ylab = NULL,
  zlab = NULL,
  line = NA,
  ...
)
}
\arguments{
\item{main}{The main title for the plot.}

\item{sub}{The subtitle for the plot.}

\item{xlab}{The axis labels for the plot .}

\item{ylab}{The axis labels for the plot .}

\item{zlab}{The axis labels for the plot .}

\item{line}{The ``line'' of the plot margin to draw the label on.}

\item{...}{Additional parameters which are passed to \code{\link[=plotMTeX3D]{plotMTeX3D()}}.}
}
\value{
The object IDs of objects added to the scene.
}
\description{
Draw boxes, axes and other text outside the data using TeX strings.
}
\details{
The rectangular prism holding the 3D plot has 12 edges.  They are identified
using 3 character strings.  The first character (\verb{x', }y', or \verb{z') selects the direction of the axis.  The next two characters are each }-' or \verb{+', selecting the lower or upper end of one of the other coordinates.  If only one or two characters are given, the remaining characters default to }-'.
For example \code{edge = 'x+'} draws an x-axis at the high level of y and the
low level of z.

By default, \code{\link[rgl:axes3d]{rgl::axes3d()}} uses the \code{\link[rgl:bbox]{rgl::bbox3d()}} function to draw the axes.
The labels will move so that they do not obscure the data.  Alternatively,
a vector of arguments as described above may be used, in which case
fixed axes are drawn using \code{\link[rgl:axes3d]{rgl::axis3d()}}.

If \code{pos} is a numeric vector of length 3, \code{edge} determines
the direction of the axis and the tick marks, and the values of the
other two coordinates in \code{pos} determine the position.  See the
examples.
}
\examples{
\dontrun{
ini3D(argsPlot3d = list(xlim = c(0, 2), ylim = c(0, 2), zlim = c(0, 2)))
plotTitleTeX3D(main = "\\\\LaTeX", sub = "subtitle $\\\\alpha$",
               xlab = "$x^1_2$", ylab = "$\\\\beta$", zlab = "$x\\\\cdot y$")
finalize3D()
}
}
