\name{secondStageTest}
\alias{secondStageTest}

\title{
	EXPERIMENTAL: Construct a valid level alpha test for the second stage of an
	adaptive design that is based on a pre-planned graphical MCP
}
\description{
        Based on a pre-planned graphical multiple comparison procedure,
	construct a valid multiple level alpha test that conserves the 
	family wise error in the strong sense regardless of any trial
	adaptations during an unblinded interim analysis. -
	Implementation of adaptive procedures is still in an 
	early stage and may change in the near future 
}
\usage{
	secondStageTest(interim, select, matchCE=TRUE, 
                  zWeights="reject", G2=interim@preplanned)
}

\arguments{
  \item{interim}{
	An object of class \code{\link{gPADInterim}}.
  }
  \item{select}{
  	A logical vector giving specifying which hypotheses are carried
  forward to the second stage
  } 
  \item{matchCE}{
        Logical specifying whether second stage weights should be
  computed proportional to corresponding PCEs
  }
  \item{zWeights}{
    Either "reject","accept", or "strict" giving the rule what should be
  done in cases where none of the selected hypotheses has positive
  second stage weight.
  }
  \item{G2}{
  	An object of class \code{\link{graphMCP}} laying down the rule
  to compute second stage weights. Defaults to pre-planned graph.
  }
}
\details{
	For details see the given references.
}
\value{
  A function of signature \code{function(z2)} with arguments:
  \item{z2}{
    A numeric vector with second stage z-scores. Z-scores of dropped
    hypotheses should be set no \code{NA},
  }
  that returns objects of class \code{\link{gMCPResult}}.
}
\references{
Frank Bretz, Willi Maurer, Werner Brannath, Martin Posch:
A graphical approach to sequentially rejective multiple test procedures.
Statistics in Medicine 2009 vol. 28 issue 4 page 586-604. 
\url{http://www.meduniwien.ac.at/fwf_adaptive/papers/bretz_2009_22.pdf}

Bretz F., Posch M., Glimm E., Klinglmueller F., Maurer W., Rohmeyer K. (2011):
Graphical approaches for multiple endpoint problems using weighted Bonferroni, Simes or parametric tests - to appear.

Posch M, Futschik A (2008): A Uniform Improvement of Bonferroni-Type Tests
by Sequential Tests JASA 103/481, 299-308

Posch M, Maurer W, Bretz F (2010): Type I error rate control in adaptive designs
for confirmatory clinical trials with treatment selection at interim
Pharm Stat 10/2, 96-104
}
\author{
Florian Klinglmueller \email{float@lefant.net}
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{graphMCP}}, \code{\link{doInterim}}
}
\examples{

## Simple successive graph (Maurer et al. 2011)
## two treatments two hierarchically ordered endpoints
a <- .025
G <- simpleSuccessiveI()
## some z-scores:

p1=c(.1,.12,.21,.16)
z1 <- qnorm(1-p1)
p2=c(.04,1,.14,1)
z2 <- qnorm(1-p2)
v <- c(1/2,1/3,1/2,1/3)

intA <- doInterim(G,z1,v)

## select only the first treatment 
fTest <- secondStageTest(intA,c(1,0,1,0))


}
\keyword{ htest }
\keyword{ graphs }

