% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gMCP.R
\name{gMCP}
\alias{gMCP}
\title{Graph based Multiple Comparison Procedures}
\usage{
gMCP(graph, pvalues, test, correlation, alpha = 0.05, approxEps = TRUE,
  eps = 10^(-3), ..., upscale = ifelse(missing(test) &&
  !missing(correlation) || !missing(test) && test == "Bretz2011", TRUE, FALSE),
  useC = FALSE, verbose = FALSE, keepWeights = FALSE, adjPValues = TRUE)
}
\arguments{
\item{graph}{A graph of class \code{\link{graphMCP}}.}

\item{pvalues}{A numeric vector specifying the p-values for the graph based
MCP. Note the assumptions in the details section for the parametric tests, 
when a correlation is specified.}

\item{test}{Should be either \code{"Bonferroni"}, \code{"Simes"} or \code{"parametric"}.
If not specified by default the Bonferroni-based test procedure is used if no
correlation is specified or the algorithm from Bretz et al. 2011 if a
correlation is specified. If \code{test} is set to \code{"Simes"} the weighted
Simes test will be performed for each subset of hypotheses.}

\item{correlation}{Optional correlation matrix.  If the weighted Simes test
is performed, it is checked whether type I error rate can be ensured and a
warning is given if this is not the case.  For parametric tests the p-values
must arise from one-sided tests with multivariate normal distributed test
statistics for which the correlation is (partially) known. In that case a
weighted parametric closed test is performed (also see
\code{\link{generatePvals}}). Unknown values can be set to NA. (See details
for more information)}

\item{alpha}{A numeric specifying the maximal allowed type one error rate.}

\item{approxEps}{A boolean specifying whether epsilon values should be
substituted with the value given in the parameter \code{eps}.}

\item{eps}{A numeric scalar specifying a value for epsilon edges.}

\item{...}{Test specific arguments can be given here.}

\item{upscale}{Logical. If \code{upscale=FALSE} then for each intersection 
of hypotheses (i.e. each subgraph) a weighted test is performed at the 
possibly reduced level alpha of sum(w)*alpha, 
where sum(w) is the sum of all node weights in this subset.
If \code{upscale=TRUE} all weights are upscaled, so that sum(w)=1.

For backward comptibility the default value is TRUE if a the parameter \code{test}
is missing, but parameter \code{correlation} is specified or if \code{test=="Bretz2011"}.}

\item{useC}{Logical scalar. If \code{TRUE} neither adjusted p-values nor
intermediate graphs are returned, but the calculation is sped up by using
code written in C. THIS CODE IS NOT FOR PRODUCTIVE USE YET!  If approxEps is
\code{FALSE} and the graph contains epsilon edges, a warning is thrown and
\code{useC} will be ignored.}

\item{verbose}{Logical scalar. If \code{TRUE} verbose output is generated.}

\item{keepWeights}{Logical scalar. If \code{FALSE} the weight of a node
without outgoing edges is set to 0 if it is removed.  Otherwise it keeps its
weight.}

\item{adjPValues}{Logical scalar. If \code{FALSE} no adjusted p-values will
be calculated.  Especially for the weighted Simes test this will result in
significantly less calculations in most cases.}
}
\value{
An object of class \code{gMCPResult}, more specifically a list with
elements
\describe{
\item{\code{graphs}}{list of graphs}
\item{\code{pvalues}}{p-values}
\item{\code{rejected}}{logical whether hyptheses could be rejected}
\item{\code{adjPValues}}{adjusted p-values}
}
}
\description{
Performs a graph based multiple test procedure for a given graph and
unadjusted p-values.
}
\details{
For the Bonferroni procedure the p-values can arise from any statistical
test, but if you improve the test by specifying a correlation matrix, the
following assumptions apply:

It is assumed that under the global null hypothesis
\eqn{(\Phi^{-1}(1-p_1),...,\Phi^{-1}(1-p_m))} follow a multivariate normal
distribution with correlation matrix \code{correlation} where
\eqn{\Phi^{-1}} denotes the inverse of the standard normal distribution
function.

For example, this is the case if \eqn{p_1,..., p_m} are the raw p-values
from one-sided z-tests for each of the elementary hypotheses where the
correlation between z-test statistics is generated by an overlap in the
observations (e.g. comparison with a common control, group-sequential
analyses etc.). An application of the transformation \eqn{\Phi^{-1}(1-p_i)}
to raw p-values from a two-sided test will not in general lead to a
multivariate normal distribution. Partial knowledge of the correlation
matrix is supported. The correlation matrix has to be passed as a numeric
matrix with elements of the form: \eqn{correlation[i,i] = 1} for diagonal
elements, \eqn{correlation[i,j] = \rho_{ij}}, where \eqn{\rho_{ij}} is the
known value of the correlation between \eqn{\Phi^{-1}(1-p_i)} and
\eqn{\Phi^{-1}(1-p_j)} or \code{NA} if the corresponding correlation is
unknown. For example correlation[1,2]=0 indicates that the first and second
test statistic are uncorrelated, whereas correlation[2,3] = NA means that
the true correlation between statistics two and three is unknown and may
take values between -1 and 1. The correlation has to be specified for
complete blocks (ie.: if cor(i,j), and cor(i,j') for i!=j!=j' are specified
then cor(j,j') has to be specified as well) otherwise the corresponding
intersection null hypotheses tests are not uniquely defined and an error is
returned.

For further details see the given references.
}
\examples{


g <- BonferroniHolm(5)
gMCP(g, pvalues=c(0.01, 0.02, 0.04, 0.04, 0.7))
# Simple Bonferroni with empty graph:
g2 <- matrix2graph(matrix(0, nrow=5, ncol=5))
gMCP(g2, pvalues=c(0.01, 0.02, 0.04, 0.04, 0.7))
# With 'upscale=TRUE' equal to BonferroniHolm:
gMCP(g2, pvalues=c(0.01, 0.02, 0.04, 0.04, 0.7), upscale=TRUE)

# Entangled graphs:
g3 <- Entangled2Maurer2012()
gMCP(g3, pvalues=c(0.01, 0.02, 0.04, 0.04, 0.7), correlation=diag(5))

}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}
\references{
Frank Bretz, Willi Maurer, Werner Brannath, Martin Posch: A
graphical approach to sequentially rejective multiple test procedures.
Statistics in Medicine 2009 vol. 28 issue 4 page 586-604.
\url{http://www.meduniwien.ac.at/fwf_adaptive/papers/bretz_2009_22.pdf}

Bretz F., Posch M., Glimm E., Klinglmueller F., Maurer W., Rohmeyer K.
(2011): Graphical approaches for multiple endpoint problems using weighted
Bonferroni, Simes or parametric tests. Biometrical Journal 53 (6), pages 894-913, Wiley.
\url{http://onlinelibrary.wiley.com/doi/10.1002/bimj.201000239/full}

Strassburger K., Bretz F.: Compatible simultaneous lower confidence bounds
for the Holm procedure and other Bonferroni based closed tests. Statistics
in Medicine 2008; 27:4914-4927.

Hommel G., Bretz F., Maurer W.: Powerful short-cuts for multiple testing
procedures with special reference to gatekeeping strategies. Statistics in
Medicine 2007; 26:4063-4073.

Guilbaud O.: Simultaneous confidence regions corresponding to Holm's
stepdown procedure and other closed-testing procedures. Biometrical Journal
2008; 50:678-692.
}
\seealso{
\code{\link{graphMCP}} \code{\link[multcomp:contrMat]{graphNEL}}
}
\keyword{graphs}
\keyword{htest}

