/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.config;

import java.io.File;
import java.text.DecimalFormat;
import org.mutoss.config.Configuration;
import org.mutoss.config.SpecificConfig;

public class GeneralConfig
extends SpecificConfig {
    public static final String DISABLE = "disable";
    DecimalFormat format = null;

    GeneralConfig(Configuration conf) {
        super(conf);
    }

    public void setTempDir(String tempDir) {
        this.setProperty("tempdir", tempDir);
    }

    public String getTempDir() {
        String tmpDir = this.getProperty("tempdir", "");
        if (tmpDir.trim().equals("")) {
            tmpDir = System.getProperty("java.io.tmpdir");
        }
        return tmpDir;
    }

    public File getProjectPDFsPath() {
        return new File(this.getProperty("pdf.output", System.getProperty("user.dir")));
    }

    public void setProjectPDFsPath(String path) {
        this.setProperty("pdf.output", path);
    }

    public void setPDFViewerPath(String pdfViewerPath) {
        this.setProperty("acrobat.path", pdfViewerPath);
    }

    public String getPDFViewerPath() {
        return this.getProperty("acrobat.path", "");
    }

    public void setPDFViewerOptions(String pdfViewerOptions) {
        this.setProperty("pdfviewer.options", pdfViewerOptions);
    }

    public String getPDFViewerOptions() {
        return this.getProperty("pdfviewer.options", "");
    }

    public void setFontSize(int i) {
        this.setIntProperty("font.size", i);
    }

    public int getFontSize() {
        return this.getIntProperty("font.size", "12");
    }

    public void setGridSize(int grid) {
        this.setProperty("grid", "" + grid);
    }

    public int getGridSize() {
        return Integer.parseInt(this.getProperty("grid", "10"));
    }

    public void setDigits(int digit) {
        this.setProperty("digit", "" + digit);
        this.setFormat();
    }

    public int getDigits() {
        return Integer.parseInt(this.getProperty("Digits", "3"));
    }

    public DecimalFormat getDecFormat() {
        if (this.format == null) {
            this.setFormat();
        }
        return this.format;
    }

    private void setFormat() {
        String s = "#.";
        for (int i = 0; i < this.getDigits(); ++i) {
            s = s + "#";
        }
        this.format = new DecimalFormat(s);
    }

    public void setLineWidth(int lw) {
        this.setProperty("linewidth", "" + lw);
    }

    public int getLineWidth() {
        return Integer.parseInt(this.getProperty("linewidth", "2"));
    }

    public void setEps(double eps) {
        this.setProperty("epsilon", "" + eps);
    }

    public double getEpsilon() {
        return Double.parseDouble(this.getProperty("epsilon", "0.0001"));
    }

    public boolean showFractions() {
        return Boolean.parseBoolean(this.getProperty("showFractions", "true"));
    }

    public void setShowFractions(boolean showFractions) {
        this.setProperty("showFractions", "" + showFractions);
    }

    public boolean getColoredImages() {
        return Boolean.parseBoolean(this.getProperty("coloredImages", "true"));
    }

    public void setColoredImages(boolean colored) {
        this.setProperty("coloredImages", "" + colored);
    }

    public int getDigitsInTables() {
        return Integer.parseInt(this.getProperty("digits.in.tables", "6"));
    }

    public boolean showRejected() {
        return Boolean.parseBoolean(this.getProperty("showRejected", "true"));
    }

    public void setShowRejected(boolean showRejected) {
        this.setProperty("showRejected", "" + showRejected);
    }

    public boolean useEpsApprox() {
        return Boolean.parseBoolean(this.getProperty("useEpsApprox", "false"));
    }

    public void setUseEpsApprox(boolean useEpsApprox) {
        this.setProperty("useEpsApprox", "" + useEpsApprox);
    }
}

