% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcovFWB.R
\name{vcovFWB}
\alias{vcovFWB}
\title{Fractional Weighted Bootstrap Covariance Matrix Estimation}
\usage{
vcovFWB(
  x,
  cluster = NULL,
  R = 1000,
  start = FALSE,
  ...,
  fix = FALSE,
  use = "pairwise.complete.obs",
  verbose = FALSE,
  cl = NULL
)
}
\arguments{
\item{x}{a fitted model object, such as the output of a call to \code{lm()} or \code{glm()}. The model object must result from a function that can be updated using \code{\link[=update]{update()}} and has a \code{weights} argument to input non-integer case weights.}

\item{cluster}{a variable indicating the clustering of observations,
    a \code{list} (or \code{data.frame}) thereof, or a formula specifying
    which variables from the fitted model should be used (see examples).
    By default (\code{cluster = NULL}), either \code{attr(x, "cluster")} is used
    (if any) or otherwise every observation is assumed to be its own cluster.}

\item{R}{the number of bootstrap replications.}

\item{start}{\code{logical}; should \code{coef(x)} be passed as \code{start} to the \code{update(x, weights = ...)} call? In case the model \code{x} is computed by some numeric iteration, this may speed up the bootstrapping.}

\item{...}{ignored.}

\item{fix}{\code{logical}; if \code{TRUE}, the covariance matrix is fixed to be positive semi-definite in case it is not.}

\item{use}{\code{character}; specification passed to \code{\link[stats:cor]{stats::cov()}} for handling missing coefficients/parameters.}

\item{verbose}{\code{logical}; whether to display a progress bar.}

\item{cl}{a cluster object created by \pkgfun{parallel}{makeCluster}, or an integer to indicate the number of child-processes (integer values are ignored on Windows) for parallel evaluations. See \pkgfun{pbapply}{pblapply} for details. If \code{NULL}, no parallelization will take place.}
}
\value{
A matrix containing the covariance matrix estimate.
}
\description{
\code{vcovFWB()} estimates the covariance matrix of model coefficient estimates using the fractional weighted bootstrap. It serves as a drop-in for \code{stats::vcov()} or \code{sandwich::vcovBS()}. Clustered covariances are can be requested.
}
\details{
\code{vcovFWB()} functions like other \code{vcov()}-like functions, such as those in the \code{sandwich} package, in particular, \pkgfun{sandwich}{vcovBS}, which implements the traditional bootstrap (and a few other bootstrap varieties for linear models). Sets of weights are generated as described in the documentation for \code{\link[=fwb]{fwb()}}, and the supplied model is re-fit using those weights. When the fitted model already has weights, these are multiplied by the bootstrap weights.

For \code{lm} objects, the model is re-fit using \code{\link[=.lm.fit]{.lm.fit()}} for speed, and, similarly, \code{glm} objects are re-fit using \code{\link[=glm.fit]{glm.fit()}} (or whichever fitting method was originally used). For other objects, \code{\link[=update]{update()}} is used to populate the weights and re-fit the model (this assumes the fitting function accepts non-integer case weights through a \code{weights} argument). If a model accepts weights in some other way, \code{\link[=fwb]{fwb()}} should be used instead; \code{vcovFWB()} is inherently limited in its ability to handle all possible models. It is important that the original model was not fit using frequency weights (i.e., weights that allow one row of data to represent multiple full, identical, individual units).

See \pkgfun{sandwich}{vcovBS} and \pkgfun{sandwich}{vcovCL} for more information on clustering covariance matrices, and see \code{\link[=fwb]{fwb()}} for more information on how clusters work with the fractional weighted bootstrap. When clusters are specified, each cluster is given a bootstrap weight, and all members of the cluster are given that weight; estimation then proceeds as normal. By default, when \code{cluster} is unspecified, each unit is considered its own cluster.
}
\examples{
\dontshow{if (requireNamespace("lmtest", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set.seed(123)
data("infert")
fit <- glm(case ~ spontaneous + induced, data = infert,
             family = "binomial")
lmtest::coeftest(fit, vcov. = vcovFWB, R = 200)
\dontshow{\}) # examplesIf}
\dontshow{if (requireNamespace("sandwich", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example from help("vcovBS", package = "sandwich")
data("PetersenCL", package = "sandwich")
m <- lm(y ~ x, data = PetersenCL)

# Note: this is not to compare performance, just to
# demonstrate the syntax
cbind(
  "BS" = sqrt(diag(sandwich::vcovBS(m))),
  "FWB" = sqrt(diag(vcovFWB(m))),
  "BS-cluster" = sqrt(diag(sandwich::vcovBS(m, cluster = ~firm))),
  "FWB-cluster" = sqrt(diag(vcovFWB(m, cluster = ~firm)))
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=fwb]{fwb()}} for performing the fractional weighted bootstrap on an arbitrary quantity; \code{\link[=fwb.ci]{fwb.ci()}} for computing nonparametric confidence intervals for \code{fwb} objects; \code{\link[=summary.fwb]{summary.fwb()}} for producing standard errors and confidence intervals for \code{fwb} objects; \pkgfun{sandwich}{vcovBS} for computing covariance matrices using the traditional bootstrap
}
