# WARNING - Generated by {fusen} from dev/flat_deal_with_flat_files.Rmd: do not edit by hand

#' Deprecate a flat file
#'
#' It is not inflated again during `[inflate_all()]` as it is
#' identified as deprecated in the config file.
#' Previously generated files get "do not edit by hand" message removed.
#' The flat file is moved to "dev/flat_history".
#'
#' @param flat_file Path to the flat file to deprecate
#'
#' @return Used for side effect.
#' Move flat file to "dev/flat_history", update config file,
#' and remove "do not edit by hand" message.
#'
#' @export
#' @examples
#' \dontrun{
#' # These functions change the current user workspace
#' dev_file <- suppressMessages(
#'   add_flat_template(
#'     template = "add",
#'     pkg = dummypackage, overwrite = TRUE, open = FALSE
#'   )
#' )
#' deprecate_flat_file(flat_file = "dev/flat_additional.Rmd")
#' }
deprecate_flat_file <- function(flat_file) {
  # Read config file
  config_file <- getOption("fusen.config_file", "dev/config_fusen.yaml")
  config <- yaml::read_yaml(config_file)

  if (!file.exists(flat_file)) {
    stop(
      paste0(
        "The flat file ", basename(flat_file),
        " does not exist."
      )
    )
  } else if (!basename(flat_file) %in% names(config)) {
    stop(
      paste0(
        "The flat file ", basename(flat_file),
        " is not in the config file.",
        "Did you inflate it with {fusen}?"
      )
    )
  } else if (config[[basename(flat_file)]]$state == "deprecated") {
    cli_alert_warning(
      paste0(
        "The flat file ", basename(flat_file),
        " is already deprecated."
      )
    )
    return(invisible())
  }

  if (!dir.exists(file.path(dirname(config_file), "flat_history"))) {
    dir.create(file.path(dirname(config_file), "flat_history"))
  }

  # Update config file
  config[[basename(flat_file)]]$state <- "deprecated"
  config[[basename(flat_file)]]$path <-
    file.path("dev", "flat_history", basename(flat_file))
  config[[basename(flat_file)]]$inflate$flat_file <-
    file.path("dev", "flat_history", basename(flat_file))

  # Update flat file after the yaml header
  lines <- readLines(flat_file)
  lines <- c(
    "<!-- # WARNING - flat file now deprecated. do not edit by hand, do not inflate -->",
    lines
  )
  write_utf8(lines = lines, path = flat_file)

  # Update linked files
  all_linked_files <- unlist(
    config[[basename(flat_file)]][
      c("R", "tests", "vignettes")
    ]
  )
  for (file in all_linked_files) {
    lines <- readLines(file)
    lines <- lines[!grepl("# do not edit by hand", lines)]
    yaml_pos <- grep("^---$", lines)[2]

    if (
      grepl("(R|r)md|(Q|q)md", tools::file_ext(file)) &&
        !is.na(yaml_pos) && length(yaml_pos) > 0) {
      # add just after the yaml header

      lines <- c(
        lines[1:yaml_pos],
        paste0(
          "\n",
          "<!-- # Previously generated by {fusen} from ",
          file.path("dev", "flat_history", basename(flat_file)),
          ": now deprecated. -->",
          "\n"
        ),
        lines[(yaml_pos + 1):length(lines)]
      )
    } else {
      # first line
      lines <- c(
        paste0(
          "# Previously generated by {fusen} from ",
          file.path("dev", "flat_history", basename(flat_file)),
          ": now deprecated."
        ),
        lines
      )
    }

    write_utf8(lines = lines, path = file)
  }

  # Move flat file to flat_history
  dir.create(file.path("dev", "flat_history"), showWarnings = FALSE)
  file.copy(flat_file, file.path("dev", "flat_history", basename(flat_file)))
  file.remove(flat_file)

  # Write config file
  write_yaml_verbatim(config, config_file)

  cli_alert_success(
    paste0(
      "The flat file ", basename(flat_file),
      " has been deprecated."
    )
  )
}
