% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models_lib.R
\name{gain_lift}
\alias{gain_lift}
\title{Generates lift and cumulative gain performance table and plot}
\usage{
gain_lift(data, str_score, str_target, q_segments = 10)
}
\arguments{
\item{data}{input data source}

\item{str_score}{the variable which contains the score number, or likelihood of being positive class}

\item{str_target}{target binary variable indicating class label}

\item{q_segments}{quantity of segments to split str_score, valid values: 5, 10 or 20}
}
\value{
lift/gain table, column: gain implies how much positive cases are catched if the cut point to define the
positive class is set to the column "Score Point"
}
\description{
It retrieves the cumulative positive rate -gain curve- and the lift chart & plot when score is divided
in 5, 10 or 20 segments. Both metrics give a quality measure about how well the model predicts.
Higher values at the beginning of the population implies a better model. More info at:
 \url{https://livebook.datascienceheroes.com/model-performance.html#scoring_data}
}
\examples{
fit_glm=glm(has_heart_disease ~ age + oldpeak, data=heart_disease, family = binomial)
heart_disease$score=predict(fit_glm, newdata=heart_disease, type='response')
gain_lift(data=heart_disease,str_score='score',str_target='has_heart_disease')

}
