% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{efFourier}
\alias{efFourier}
\title{Calculate the first M Fourier basis functions}
\usage{
efFourier(argvals, M, linear = FALSE)
}
\arguments{
\item{argvals}{A vector, defining a (fine) grid on the interval for which the
Fourier basis functions are computed.}

\item{M}{An integer, specifying the number of basis functions that are
calculated.}

\item{linear}{Logical. If \code{TRUE}, the last function is not a Fourier
function but the linear function orthogonalized to all previous Fourier
basis functions. Defaults to \code{FALSE}. See Details.}
}
\value{
A univariate functional data object of class
  \code{\linkS4class{funData}} containing the Fourier basis functions on
  the given interval.
}
\description{
This function calculates the first M orthonormal Fourier basis functions on
an arbitrary interval.
}
\details{
If \code{linear}, the last basis function does not belong to the  Fourier
basis, but is the linear function orthogonalized to all previous Fourier
basis functions via the Gram-Schmidt method. This is implemented only if
\code{argvalss} is a grid defining the unit interval \eqn{[0,1]}.
}
\seealso{
\code{\linkS4class{funData}}, \code{\link{simFunData}}, \code{\link{simMultiFunData}}
}
\keyword{internal}
