% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ft_search.R
\name{ft_search}
\alias{ft_search}
\alias{ft_search_ls}
\title{Search for full text}
\usage{
ft_search(
  query,
  from = "plos",
  limit = 10,
  start = 0,
  plosopts = list(),
  bmcopts = list(),
  crossrefopts = list(),
  entrezopts = list(),
  arxivopts = list(),
  biorxivopts = list(),
  euroopts = list(),
  scopusopts = list(),
  maopts = list(),
  ...
)

ft_search_ls()
}
\arguments{
\item{query}{(character) Query terms}

\item{from}{(character) Source to query, one or more of \code{"plos"}, \code{"bmc"},
\code{"crossref"}, \code{"entrez"}, \code{"arxiv"}, \code{"biorxiv"}, \code{"europmc"}, \code{"scopus"},
or \code{"ma"}}

\item{limit}{(integer) Number of records to return. default: 10. See also
Pagination section below.}

\item{start}{(integer) Record number to start at. Only used for
'scopus' right now. default: 0. Note that with some data sources we loop
internally to get all the results you want with the \code{limit} parameter, so
\code{start} in those cases will be ignored. See \strong{Looping} section below.}

\item{plosopts}{(list) PLOS options, a named list. See \code{\link[rplos:searchplos]{rplos::searchplos()}}}

\item{bmcopts}{(list) BMC options, a named list. See \code{\link[=bmc_search]{bmc_search()}}}

\item{crossrefopts}{(list) Crossref options, a named list.
See \code{\link[rcrossref:cr_works]{rcrossref::cr_works()}}}

\item{entrezopts}{(list) Entrez options, a named list.
See \code{\link[rentrez:entrez_search]{rentrez::entrez_search()}}}

\item{arxivopts}{(list) arxiv options, a named list.
See \code{\link[aRxiv:arxiv_search]{aRxiv::arxiv_search()}}}

\item{biorxivopts}{(list) biorxiv options, a named list.
See \code{\link[=biorxiv_search]{biorxiv_search()}}}

\item{euroopts}{(list) Euro PMC options, a named list. See \code{\link[=eupmc_search]{eupmc_search()}}}

\item{scopusopts}{(list) Scopus options, a named list.
See \code{\link[=scopus_search]{scopus_search()}}}

\item{maopts}{(list) Microsoft Academic options, a named list. See
\code{\link[=microsoft_search]{microsoft_search()}}}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}, see
examples below. curl options are ignored for: arxiv (however, you
can wrap your call to arxiv in \code{httr::with_config})}
}
\value{
An object of class \code{ft}, and objects of class \code{ft_ind}
within each source. You can access each data source with \code{$}
}
\description{
\code{ft_search} is a one stop shop for searching for articles
across many publishers and repositories. We currently support search for
PLOS via the  \pkg{rplos} package, Crossref via the \pkg{rcrossref}
package, Entrez via the \pkg{rentrez} package, arXiv via the \pkg{aRxiv}
package, and BMC, Biorxiv, EuropePMC, and Scopus via internal helper
functions in this package.

Many publishers' content is searchable via Crossref and Entrez - of course
this doesn't mean that we can get full text for those articles. In the
output objects of this function, we attempt to help by indicating what
license is used for articles.
}
\details{
Each of \code{plosopts}, \code{scopusopts}, etc. expect
a named list.

See \strong{Rate Limits} and \strong{Authentication} in
\link{fulltext-package} for rate limiting and authentication information,
respectively

See https://dev.elsevier.com/sc_search_tips.html for help/tips
on searching with Scopus
}
\note{
for all \verb{*opts} parameters, see the function linked to in
the parameter definition for what you can pass to it.
}
\section{Looping}{

Note that we necessarily have to treat different sources/publishers
differently internally in this function. Some we can search and get
back as many results as desired automatically, while with others you'd
have to manually iterate through to get all your results.
Notes on different sources:
\itemize{
\item PLOS: \code{\link[rplos:searchplos]{rplos::searchplos()}} used and includes internal looping of
requests
\item BMC: using internal function \code{bmc_search} that does not
loop, so you have to iterate through requests manually
\item Crossref: \code{\link[rcrossref:cr_works]{rcrossref::cr_works()}} used, but does not include
internal looping of requests, but the max limit for one request
is relatively high at 1000
\item Entrez: \code{\link[rentrez:entrez_search]{rentrez::entrez_search()}} used, but does not include
internal looping of requests
\item arXiv: \code{\link[aRxiv:arxiv_search]{aRxiv::arxiv_search()}} used and includes internal looping
of requests
\item BiorXiv: using internal function \code{biorxiv_search} that does not
loop, so you have to iterate through requests manually
\item Europe BMC: using internal function \code{eupmc_search} that does not
loop, so you have to iterate through requests manually
\item Scopus: using internal function \code{scopus_search_loop} that does
include internal looping of requests
\item Microsoft AR: using internal function \code{microsoft_search} that does not
loop, so you have to iterate through requests manually
}
}

\section{Pagination}{

For each data source you can pass named parameters to a list matching
that data source name, e.g., \code{plosopts} for PLOS. If you pass pagination
parameters per data source they will override the global pagination
parameters set in \code{ft_search()}. They are for each data source
(limit parameter name/offset parameter name):
\itemize{
\item PLOS: \code{limit}/\code{start}
\item Crossref: \code{limit}/\code{offset}
\item BMC: \code{limit}/\code{offset}
\item Entrez: \code{retmax}/\code{retstart}
\item Europe PMC: \code{per_page}/(see \code{\link[=eupmc_search]{eupmc_search()}})
\item arXiv: \code{limit}/\code{start}
\item BioRxiv: \code{limit}/none
\item Scopus: \code{count}/\code{start}
\item Microsoft Academic: \code{count}/\code{offset}
}
}

\examples{
# List publishers included
ft_search_ls()

\dontrun{
# Plos
(res1 <- ft_search(query='ecology', from='plos'))
res1$plos
ft_search(query='climate change', from='plos', limit=500, 
  plosopts=list(
   fl=c('id','author','eissn','journal','counter_total_all',
   'alm_twitterCount')))

# Crossref
(res2 <- ft_search(query='ecology', from='crossref'))
res2$crossref

# BioRxiv
(res <- ft_search(query='owls', from='biorxiv'))
res$biorxiv

# Entrez
(res <- ft_search(query='ecology', from='entrez'))
res$entrez

# arXiv
(res <- ft_search(query='ecology', from='arxiv'))
res$arxiv

# BMC - can be very slow
(res <- ft_search(query='ecology', from='bmc'))
res$bmc

# Europe PMC
(res <- ft_search(query='ecology', from='europmc'))
res$europmc
## get the next batch of results, using the cursorMark result
ft_search(query='ecology', from='europmc', 
  euroopts = list(cursorMark = res$europmc$cursorMark))

# Scopus
(res <- ft_search(query = 'ecology', from = 'scopus', limit = 100,
   scopusopts = list(key = Sys.getenv('ELSEVIER_SCOPUS_KEY'))))
res$scopus
## pagination
(res <- ft_search(query = 'ecology', from = 'scopus', 
   scopusopts = list(key = Sys.getenv('ELSEVIER_SCOPUS_KEY')), limit = 5))
## lots of results
(res <- ft_search(query = "ecology community elk cow", from = 'scopus', 
   limit = 100,
   scopusopts = list(key = Sys.getenv('ELSEVIER_SCOPUS_KEY'))))
res$scopus
## facets
## FIXME: apparently I don't have access to facets anymore
# (res <- ft_search(query = 'ecology', from = 'scopus', 
#   scopusopts = list(
#     key = Sys.getenv('ELSEVIER_SCOPUS_KEY'), 
#     facets = "subjarea(count=5)"
#   ), limit = 5))
# res$scopus

# PLOS, Crossref, and arxiv
(res <- ft_search(query='ecology', from=c('plos','crossref','arxiv')))
res$plos
res$arxiv
res$crossref

# Microsoft academic search
key <- Sys.getenv("MICROSOFT_ACADEMIC_KEY")
(res <- ft_search("Y='19'...", from = "microsoft", maopts = list(key = key)))
res$ma$data$DOI

# curl options
ft_search(query='ecology', from='plos', verbose = TRUE)
ma_key <- Sys.getenv("MICROSOFT_ACADEMIC_KEY")
ft_search("Y='19'...", from='microsoft', maopts = list(key = ma_key),
  verbose = TRUE)
}
}
