% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spa_functions.R
\name{fsr_diff_operators}
\alias{fsr_diff_operators}
\alias{f_diff}
\alias{f_bound_diff}
\alias{f_symm_diff}
\alias{f_abs_diff}
\title{Fuzzy difference operators}
\usage{
f_diff(x, y)

f_bound_diff(x, y)

f_symm_diff(x, y)

f_abs_diff(x, y)
}
\arguments{
\item{x}{A numerical vector whose values are in [0, 1].}

\item{y}{A numerical vector whose values are in [0, 1].}
}
\value{
A numerical vector.
}
\description{
Fuzzy difference operations are set operations that generalize Boolean difference operations.
This family of functions implements some operators that help us to define different fuzzy difference operations.
These operators receive two numerical values in [0, 1] as input and calculates another numerical value in [0, 1] as output.
}
\details{
These functions calculate the resulting membership degree of a fuzzy difference operator applied on two numerical values in the interval [0, 1].
The following fuzzy difference operators are available:
\itemize{
\item \code{f_diff}: The standard \emph{fuzzy set difference} operator defined as the intersection of \code{x} and the complement of \code{y}, that is, \code{min(x, 1 - y)}.
\item \code{f_bound_diff}: The \emph{fuzzy bounded difference} operator defined as \code{x} minus \code{y} with upper bound equal to 0, that is, \code{max(0, x - y)}.
\item \code{f_symm_diff}: The \emph{fuzzy symmetric difference} operator defined as the union of the difference of \code{x} and \code{y} and the difference of \code{y} and \code{x}, that is, \code{max(f_diff(x, y), f_diff(y, x))}.
\item \code{f_abs_diff}: The \emph{fuzzy absolute difference} operator defined as the absolute difference of \code{x} and \code{y}, that is, \code{abs(x - y)}.
}

These operators are useful to process the function \code{spa_difference} since one of them can be informed as a parameter for this function.
}
\examples{

x <- c(0.1, 0.3, 0.6, 0.8)
y <- c(0.9, 0.7, 0.4, 0.2)

f_diff(x, y)
f_bound_diff(x, y)
f_symm_diff(x, y)
f_abs_diff(x, y)

}
