% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsi_functions.R
\name{visitation}
\alias{visitation}
\title{Visitation: An example of FSI model}
\usage{
visitation()
}
\value{
An example of an FSI model implemented without fuzzy rules set.
}
\description{
This function provides an example, without rules, of a fuzzy spatial inference (FSI) model.
}
\details{
The FSI model provided by this function represents an FSI model to estimate the visiting experience based on prices and overall ratings of accommodations as well as sanitary conditions of restaurants. The output of such a model infers a value between 0 and 100 that indicates how attractive it is to visit a specific location. For this, the experience can be classified as \emph{awful}, \emph{average}, and \emph{great}.

The linguistic variables and their linguistic values of this FSI model are listed below:
\itemize{
\item \emph{accommodation price}, with  \emph{cut-rate}, \emph{affordable}, and \emph{expensive} as linguistic values;
\item \emph{accommodation review} with \emph{bad}, \emph{good}, and \emph{excellent} as linguistic values;
\item \emph{food safety} with \emph{low}, \emph{medium}, and \emph{high} as linguistic values, which represent levels of sanitary conditions.
}

The usage of FSI models is subdivided into a \emph{preparation phase} and an \emph{evaluation phase}. The preparation phase is responsible for instantiating a new FSI model with the elements of the data source component of FIFUS. For this, the fsr package provides the following functions: \code{fsi_create}, \code{fsi_add_fsa}, and \code{fsi_add_cs}. These functions are employed by \code{visitation} so that users can add their own fuzzy set rules (by using \code{fsi_add_rules}) and perform the evaluation phase (by using the functions \code{fsi_eval} and/or \code{fsi_qw_eval}).
In this sense, \code{visitation} performs the following internal actions to return an FSI model:
\enumerate{
\item specify the linguistic variables and their corresponding linguistic values, which are in turn represented by membership functions generated by the function \code{genmf} of the FuzzyR package. These items are specified according to the context of the running example.
\item define small point datasets that represent each linguistic variable. Such datasets are \code{tibble} objects.
\item build spatial plateau objects by using the function \code{spa_creator} on the datasets. As a result, we get spatial plateau objects that represent each linguistic value.
\item create an FSI model with \code{fsi_create} function.
\item add fuzzy spatial antecedents with the \code{fsi_add_fsa} function. Recall that the antecedents are spatial plateau objects previously built.
\item define the linguistic variable and its linguistic values with membership functions for the consequent.
\item add the consequent to the FSI model by using the function \code{fsi_add_cs}.
}
}
\examples{

fsi <- visitation()

}
