% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/face_removal_mask.R
\name{get_quickshear_mask}
\alias{get_quickshear_mask}
\alias{quickshear_deface_image}
\title{Face Removal Mask using "Quickshear Defacing for Neuroimages" 
(Schimke et al. 2011)}
\usage{
get_quickshear_mask(brain_mask, buffer = 10, verbose = TRUE)

quickshear_deface_image(
  file,
  brain_mask = NULL,
  buffer = 10,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{brain_mask}{Brain mask image.  If \code{NULL}, then
\code{\link{fslbet}} will be run}

\item{buffer}{buffer to add to intercept for face mask equation}

\item{verbose}{print diagnostic messages}

\item{file}{input image - same orientation as brain mask}

\item{...}{additional arguments passed to \code{\link{fslmask}}}
}
\value{
A binary image of the non-face areas
}
\description{
Face Removal Mask using "Quickshear Defacing for Neuroimages" 
(Schimke et al. 2011)
}
\note{
adapted from 
\url{https://github.com/nipy/quickshear/blob/master/quickshear.py}
}
\examples{
\donttest{
if (have_fsl()) {
   file = "~/Downloads/sample_T1_input.nii.gz"
   if (file.exists(file)) {
       res = quickshear_deface_image(file)
       brain_mask = fslbet(file) > 0
       mask = get_quickshear_mask(brain_mask)
       image = fslmask(file, mask)
   }
}
}
}
