% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_reg.R
\name{fslepi_reg}
\alias{fslepi_reg}
\alias{fsl_epi_reg}
\alias{epi_reg}
\title{Register EPI images to Structural image}
\usage{
fslepi_reg(epi, t1, t1_brain, outfile = NULL, retimg = TRUE,
  reorient = FALSE, intern = FALSE, fmap = NULL, fmap_mag = NULL,
  fmap_mag_brain = NULL, echo_spacing = NA, phase_enc_dir = c("x",
  "y", "z", "-x", "-y", "-z"), weight = NULL, verbose = TRUE,
  opts = "", ...)

fsl_epi_reg(..., outfile = tempfile(fileext = ".nii.gz"),
  retimg = FALSE)

epi_reg(..., outfile = tempfile(fileext = ".nii.gz"), retimg = FALSE)
}
\arguments{
\item{epi}{EPI image, character or nifti object}

\item{t1}{whole head T1 image , character or nifti object}

\item{t1_brain}{brain extracted T1 image}

\item{outfile}{output registered image filename}

\item{retimg}{(logical) return image of class nifti}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link{readnii}}.}

\item{intern}{(logical) to be passed to \code{\link{system}}}

\item{fmap}{fieldmap image (in rad/s)}

\item{fmap_mag}{fieldmap magnitude image - whole head extracted}

\item{fmap_mag_brain}{fieldmap magnitude image - brain extracted}

\item{echo_spacing}{Effective EPI echo spacing 
(sometimes called dwell time) - in seconds}

\item{phase_enc_dir}{phase encoding direction, dir = x/y/z/-x/-y/-z}

\item{weight}{weighting image (in T1 space)}

\item{verbose}{(logical) print out command before running}

\item{opts}{(character) operations to be passed to \code{fslmaths}}

\item{...}{additional arguments passed to \code{\link{readnii}}.}
}
\value{
If \code{retimg} then object of class nifti.  Otherwise,
Result from system command, depends if intern is TRUE or FALSE.
}
\description{
This function calls \code{epi_reg}, designed to 
register EPI images (typically functional or diffusion) to structural 
(e.g. T1-weighted) image.
}
\note{
Functions with underscores have different defaults
and will return an output filename, so to be used for piping
}
