% Generated by roxygen2 (4.0.2): do not edit by hand
\name{fslstats}
\alias{fslstats}
\title{FSL Stats}
\usage{
fslstats(file, opts = "", verbose = TRUE, ...)
}
\arguments{
\item{file}{(character) filename of image to be checked}

\item{opts}{(character) operation passed to \code{fslstats}}

\item{verbose}{(logical) print out command before running}

\item{...}{options passed to \code{\link{checkimg}}}
}
\value{
Result of fslstats command
}
\description{
This function calls \code{fslstats}
}
\examples{
if (have.fsl()){
system.time({
x = array(rnorm(1e6), dim = c(100, 100, 100))
img = nifti(x, dim= c(100, 100, 100),
datatype = convert.datatype()$FLOAT32, cal.min = min(x),
cal.max = max(x), pixdim = rep(1, 4))
entropy = fslstats(img, opts='-E')
})
}
}

