% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cog}
\alias{cog}
\title{Image Center of Gravity}
\usage{
cog(img, thresh = 0, ceil = FALSE)
}
\arguments{
\item{img}{Object of class nifti}

\item{thresh}{threshold for image, will find \code{img > 0}}

\item{ceil}{Run \code{\link{ceiling}} to force integers (usu for plotting)}
}
\value{
Vector of length 3
}
\description{
Find Center of Gravity of Image, after thresholding
}
\examples{
if (have.fsl()){
x = array(rnorm(1e6), dim = c(100, 100, 100))
img = nifti(x, dim= c(100, 100, 100),
datatype = convert.datatype()$FLOAT32, cal.min = min(x),
cal.max = max(x), pixdim = rep(1, 4))
cog(img)
}
}

