% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadoc.R
\docType{data}
\name{forbes}
\alias{forbes}
\title{Forbes' data on air pressure in the Alps and the boiling point of water (Weisberg, 1985).}
\format{
A data frame with 17 rows and 2 variables
The variables are as follows:

\itemize{
  \item x: boiling point
  \item y: 100 x log(pressure)
}
}
\usage{
data(forbes)
}
\description{
A data set on air pressure in the Alps and the boiling point of water (Weisberg, 1985).
 There are 17 observations on the boiling point of water at different pressures, obtained
 from measurements at a variety of elevations in the Alps. The purpose of the experiment was
 to allow prediction of pressure from boiling point, which is easily measured, and so to
 provide an estimate of altitude: the higher the altitude, the lower the pressure.
 The dataset is characterized by one clear outlier.
}
\examples{
 data(forbes)
 plot(y~x, data=forbes)

}
\references{
Weisberg, S. (1985). \emph{Applied Linear Regression}. Wiley, New York.
}
\keyword{datasets}
