% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_resource.R
\name{read_resource}
\alias{read_resource}
\title{Read data from a Data Resource into a tibble data frame}
\usage{
read_resource(package, resource_name, col_select = NULL)
}
\arguments{
\item{package}{Data Package object, as returned by \code{\link[=read_package]{read_package()}} or
\code{\link[=create_package]{create_package()}}.}

\item{resource_name}{Name of the Data Resource.}

\item{col_select}{Character vector of the columns to include in the result,
in the order provided.
Selecting columns can improve read speed.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with the Data Resource's tabular data.
If there are parsing problems, a warning will alert you.
You can retrieve the full details by calling \code{\link[=problems]{problems()}} on your data
frame.
}
\description{
Reads data from a Data Resource (in a Data Package) into a tibble (a
Tidyverse data frame).
The resource must be a \href{https://specs.frictionlessdata.io/tabular-data-resource/}{Tabular Data Resource}.
The function uses \code{\link[readr:read_delim]{readr::read_delim()}} to read CSV files, passing the
resource properties \code{path}, CSV dialect, column names, data types, etc.
Column names are taken from the provided Table Schema (\code{schema}), not from
the header in the CSV file(s).
}
\details{
See \code{vignette("data-resource")}, \code{vignette("table-dialect")} and
\code{vignette("table-schema")} to learn how this function implements the
Data Package standard.
}
\examples{
# Read a datapackage.json file
package <- read_package(
  system.file("extdata", "datapackage.json", package = "frictionless")
)

package

# Read data from the resource "observations"
read_resource(package, "observations")

# The above tibble is merged from 2 files listed in the resource path
package$resources[[2]]$path

# The column names and types are derived from the resource schema
purrr::map_chr(package$resources[[2]]$schema$fields, "name")
purrr::map_chr(package$resources[[2]]$schema$fields, "type")

# Read data from the resource "deployments" with column selection
read_resource(package, "deployments", col_select = c("latitude", "longitude"))
}
\seealso{
Other read functions: 
\code{\link{read_package}()},
\code{\link{resources}()}
}
\concept{read functions}
