% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_category_related_tags.R
\name{fredr_category_related_tags}
\alias{fredr_category_related_tags}
\title{Get the related FRED tags within a category}
\usage{
fredr_category_related_tags(
  category_id,
  tag_names,
  ...,
  exclude_tag_names = NULL,
  tag_group_id = NULL,
  search_text = NULL,
  limit = NULL,
  offset = NULL,
  order_by = NULL,
  sort_order = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)
}
\arguments{
\item{category_id}{An integer ID for the category.}

\item{tag_names}{A string indicating which series tags to match.  Multiple
tags can be delimited by a semicolon in a single string (e.g. \code{"usa;gnp"}).}

\item{...}{These dots only exist for future extensions and should be empty.}

\item{exclude_tag_names}{A string indicating which series tags should \emph{not}
be matched.  Multiple tags can be delimited by a semicolon in a single string
(e.g. `"usa;gnp"``).}

\item{tag_group_id}{A string representing the tag group id to filter tags by
type.  No filtering by default.  Possible values include:
\itemize{
\item \code{"freq"} - Frequency
\item \code{"gen"} - General or Concept
\item \code{"geo"} - Geography
\item \code{"geot"} - Geography Type
\item \code{"rls"} - Release
\item \code{"seas"} - Seasonal Adjustment
\item \code{"src"} - Source
}}

\item{search_text}{A string to match text of tags.  No matching by default.}

\item{limit}{An positive integer indicating maximum number of results to return.
Possible values are any integer between \code{1} and \code{1000} (default), inclusive.}

\item{offset}{An non-negative integer used in conjunction with \code{limit} for
long series.  This mimics the idea of \emph{pagination} to retrieve large amounts
of data over multiple calls. Defaults to \code{0}.}

\item{order_by}{Order results by values of the specified attribute.
Possible values include: \code{"series_count"} (default), \verb{"popularity"``, }"created"\verb{, }"name"\verb{, }"group_id"`.}

\item{sort_order}{A string representing the order of the resulting series.
Possible values are: \code{"asc"} (default), and \code{"desc"}.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object information on related tags matching the request.
Data include tag name, group ID, popularity, series count, tag creation date,
and additional notes.
}
\description{
Get the related FRED tags for one or more FRED tags within a category.
Optionally, filter results by tag group or search.  FRED tags are attributes
assigned to series. Related FRED tags are the tags assigned to series that
match \emph{all} tags in the \emph{tag_names} parameter, \emph{no} tags in the
\emph{exclude_tag_names} parameter, and the category set by the \emph{category_id}
parameter.  Series are assigned tags and categories. Indirectly through series,
it is possible to get the tags for a category. No tags exist for a category
that does not have series.
}
\section{API Documentation}{


\href{https://fred.stlouisfed.org/docs/api/fred/category_related_tags.html}{fred/category/related_tags}
}

\examples{
if (fredr_has_key()) {
# First, get the tags for the "Production & Business Activity" category
fredr_category_tags(1L)
# Then, get the tags related to "business" and "monthly" for the
# "Production & Business Activity" category
fredr_category_related_tags(category_id = 1L, tag_names = "business;monthly")
}
}
\seealso{
\code{\link[=fredr_category]{fredr_category()}}, \code{\link[=fredr_category_children]{fredr_category_children()}}, \code{\link[=fredr_category_related]{fredr_category_related()}},
\code{\link[=fredr_category_series]{fredr_category_series()}}, \code{\link[=fredr_category_tags]{fredr_category_tags()}}
}
