% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_source_releases.R
\name{fredr_source_releases}
\alias{fredr_source_releases}
\title{Get the releases for a source}
\usage{
fredr_source_releases(source_id = NULL, limit = NULL, offset = NULL,
  order_by = NULL, sort_order = NULL, realtime_start = NULL,
  realtime_end = NULL)
}
\arguments{
\item{source_id}{An integer ID for the data source.  \emph{Required parameter}.}

\item{limit}{An integer limit on the maximum number of results to return.
Defaults to \code{1000}, the maximum.}

\item{offset}{An integer used in conjunction with limit for long series.
This mimics the idea of \emph{pagination} to retrieve large amounts of data over
multiple calls. Defaults to \code{0}.}

\item{order_by}{A string indicating which attribute should be used to order
the results.  Possible values:
\itemize{
\item \code{"release_id"} (default)
\item \code{"name"}
\item \code{"press_release"}
\item \code{"realtime_start"}
\item \code{"realtime_end"}
}}

\item{sort_order}{A string representing the order of the resulting series.
Possible values are: \code{"asc"} (default), and \code{"desc"}.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object.
}
\description{
Get the releases for a source
}
\section{API Documentation}{


\href{https://research.stlouisfed.org/docs/api/fred/source_releases.html}{fred/source/releases}
}

\examples{
\donttest{
# Board of Governors
fredr_source_releases(source_id = 1L)

# University of Michigan
fredr_source_releases(source_id = 14L, realtime_start = as.Date("1950-01-01"))
}
}
\seealso{
\code{\link[=fredr_sources]{fredr_sources()}}, \code{\link[=fredr_source]{fredr_source()}}
}
