% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_series_observations.R
\name{fredr_series_observations}
\alias{fredr_series_observations}
\alias{fredr}
\title{Get observations of a FRED series}
\usage{
fredr_series_observations(series_id = NULL, observation_start = NULL,
  observation_end = NULL, frequency = NULL, aggregation_method = NULL,
  limit = NULL, offset = NULL, sort_order = NULL, units = NULL,
  realtime_start = NULL, realtime_end = NULL, vintage_dates = NULL,
  output_type = NULL)

fredr(series_id = NULL, observation_start = NULL, observation_end = NULL,
  frequency = NULL, aggregation_method = NULL, limit = NULL,
  offset = NULL, sort_order = NULL, units = NULL, realtime_start = NULL,
  realtime_end = NULL, vintage_dates = NULL, output_type = NULL)
}
\arguments{
\item{series_id}{A string ID for the FRED series. \emph{Required parameter.}}

\item{observation_start}{A \code{Date} indicating the start of the observation period.
Defaults to \code{1776-07-04}, the earliest available date.}

\item{observation_end}{A \code{Date} indicating the end of the observation period.
Defaults to \code{9999-12-31}, the latest available date.}

\item{frequency}{A string representing a lower frequency to aggregate to.
Defaults to no frequency aggregation. Possible values are:
\itemize{
\item \code{"d"} - Daily
\item \code{"w"} - Weekly
\item \code{"bw"} - Biweekly
\item \code{"m"} - Monthly
\item \code{"q"} - Quarterly
\item \code{"sa"} - Semiannual
\item \code{"a"} - Annual
\item \code{"wem"} - Weekly, ending Monday
\item \code{"wetu"} - Weekly, ending Tuesday
\item \code{"wew"} - Weekly, ending Wednesday
\item \code{"weth"} - Weekly, ending Thursday
\item \code{"wef"} - Weekly, ending Friday
\item \code{"wesa"} - Weekly, ending Saturday
\item \code{"wesu"} - Weekly, ending Sunday
\item \code{"bwew"} - Biweekly, ending Wednesday
\item \code{"bwem"} - Biweekly, ending Monday
}}

\item{aggregation_method}{A string representing the aggregation method
used for frequency aggregation. This parameter has no affect is \code{frequency}
is not set. Possible values are:
\itemize{
\item \code{"avg"} for average
\item \code{"sum"} for sum
\item \code{"eop"} for end of period value
}}

\item{limit}{An integer limit on the maximum number of results to return.
Defaults to \code{100000}, the maximum.}

\item{offset}{An integer used in conjunction with \code{limit} for long series.
This mimics the idea of \emph{pagination} to retrieve large amounts of data over
multiple calls. Defaults to \code{0}.}

\item{sort_order}{A string representing the order of the resulting series.
Possible values are: \code{"asc"} (default), and \code{"desc"}.}

\item{units}{A string indicating the data value transformation.
Defaults to \code{"lin"}. Possible values are:
\itemize{
\item \code{"lin"} - Levels (No transformation)
\item \code{"chg"} - Change
\item \code{"ch1"} - Change from 1 year ago
\item \code{"pch"} - Percent change
\item \code{"pc1"} - Percent change from 1 year ago
\item \code{"pca"} - Compounded annual rate of change
\item \code{"cch"} - Continuously compounded rate of change
\item \code{"cca"} - Continuously compounded annual rate of change
\item \code{"log"} - Natural log
}}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://research.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{vintage_dates}{A vector of \code{Date} objects to download data for.
Vintage dates are used to download data as it existed on these specified
dates in history. They can be specified instead of a real-time period using
\code{realtime_start} and \code{realtime_end}. Defaults to no vintage dates.}

\item{output_type}{An integer indicating the output type. Not used unless
\code{realtime_start} is used. Possible values are:
\itemize{
\item \code{1} for Observations by Real-Time Period (default)
\item \code{2} for Observations by Vintage Date, All Observations
\item \code{3} for Observations by Vintage Date, New and Revised Observations Only
\item \code{4} for Observations, Initial Release Only.
}}
}
\value{
A \code{tibble} object with observation dates and values.
}
\description{
Given a series ID, return observations of that series as a \code{tibble} object.
\code{fredr()} is an alias for \code{fredr_series_observations()}.
}
\section{API Documentation}{


\href{https://research.stlouisfed.org/docs/api/fred/series_observations.html}{fred/series/observations}
}

\examples{
\donttest{
# Observations for "UNRATE" series between 1980 and 2000.  Units are in terms
# of change from pervious observation.
fredr(
  series_id = "UNRATE",
  observation_start = as.Date("1980-01-01"),
  observation_end = as.Date("2000-01-01"),
  unit = "chg"
)
# All observations for "OILPRICE" series.  The data is first aggregated by
# quarter by taking the average of all observations in the quarter then
# transformed by taking the natural logarithm.
fredr(
  series_id = "OILPRICE",
  frequency = "q",
  aggregation_method = "avg",
  unit = "log"
)

# To retrieve values for multiple series, use purrr's map_dfr() function.

if (requireNamespace("purrr", quietly = TRUE)) {

  library(purrr)
  purrr::map_dfr(c("UNRATE", "OILPRICE"), fredr)

  # Using purrr::pmap_dfr() allows you to use varying optional parameters
  params <- list(
    series_id = c("UNRATE", "OILPRICE"),
    frequency = c("m", "q")
  )

  purrr::pmap_dfr(
    .l = params,
    .f = ~ fredr(series_id = .x, frequency = .y)
  )

}

}
}
\seealso{
\code{\link[=fredr_series_search_text]{fredr_series_search_text()}},
\code{\link[=fredr_series_search_id]{fredr_series_search_id()}}, \code{\link[=fredr_series_search_tags]{fredr_series_search_tags()}},
\code{\link[=fredr_series_search_related_tags]{fredr_series_search_related_tags()}}, \code{\link[=fredr_series]{fredr_series()}}, \code{\link[=fredr_series_categories]{fredr_series_categories()}},
\code{\link[=fredr_series_release]{fredr_series_release()}}, \code{\link[=fredr_series_tags]{fredr_series_tags()}}, \code{\link[=fredr_series_updates]{fredr_series_updates()}},
\code{\link[=fredr_series_vintagedates]{fredr_series_vintagedates()}}.
}
