% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mlra}
\alias{mlra}
\title{Multiscale Lagged Regression Analysis}
\usage{
mlra(x, y, order, scales, lags, direction)
}
\arguments{
\item{x}{A real valued vector (i.e., time series data) to be analyzed.}

\item{y}{A real valued vector (i.e., time series data) to be analyzed.}

\item{order}{is an integer indicating the polynomial order used for 
detrending the local windows (e.g, 1 = linear, 2 = quadratic, etc.). There 
is a not pre-determined limit on the order of the polynomial order but the 
user should avoid using a large polynomial on small windows. This can result
in overfitting and non-meaningful estimates.}

\item{scales}{An integer vector of scales over which to compute correlation. 
Unlike univariate DFA, MRA does not require that scales be in log units.
Scale intervals can be sequential, for example, when the analysis is 
exploratory and no a priori hypotheses have been made about the scale of 
correlation. A small subset of targeted scales may also be investigated 
where scale-specific research questions exist. We have found that windows
smaller than say 8 observations create stability problems due to 
overfitting. This is espcially when the order of the fitting polynomial is 
large.}

\item{lags}{An integer indicating the maximum number of lags to include in the analysis.}

\item{direction}{A character string indicating a positive ('p') or negative ('n') lag.}
}
\value{
The object returned from the mlra() function is a list containing \code{betas} the \eqn{\beta} coefficients for each lag at each of the scales.
}
\description{
Fast function for computing multiscale lagged regression analysis (MLRA) on long time series. Combining DFA with ordinary least square regression, MLRA
is a form of fractal regression that can be used to estimate asymmetric and multiscale regression coefficients between two variables at different time-scales and temporal lags.
}
\details{
Mathematical treatment of the MLRA algorithm and its performance can be found in Kristoufek (2015) and Likens et al. (2019).

Use of the direction parameter specifies whether the scale-wise \eqn{\beta} coefficients for positive or negative lags will be estimated.  

Note that under conditions with linear and quadratic trends, Likens et al. (2019) found that there was a systematic positive bias in the \eqn{\beta} estimates for larger scales.
Using a polynomial detrending order of 2 or greater was shown to attenuate this bias.
}
\examples{
# Here is a simple example for running MLRA using a white noise and pink noise time series.
# For more detailed examples, see the vignette. 

noise <- rnorm(5000)

pink.noise <- fgn_sim(n = 5000, H = 0.9)

scales <- logscale(scale_min = 10, scale_max = 1250, scale_ratio = 1.1)

mlra.out <- mlra(
    x = noise, 
    y = pink.noise, 
    order = 1, 
    scales = scales, 
    lags = 100, direction = 'p')




}
\references{
Kristoufek, L. (2015). Detrended fluctuation analysis as a regression framework: Estimating dependence at different scales. Physical Review E, 91(2), 022802.

Likens, A. D., Amazeen, P. G., West, S. G., & Gibbons, C. T. (2019). Statistical properties of Multiscale Regression Analysis: Simulation and application to human postural control. Physica A: Statistical Mechanics and its Applications, 532, 121580.
}
