% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_ARFIMA.R
\name{mc_ARFIMA}
\alias{mc_ARFIMA}
\title{Mixed-correlated ARFIMA processes}
\usage{
mc_ARFIMA(
  process,
  n,
  rho,
  d1 = NULL,
  d2 = NULL,
  d3 = NULL,
  d4 = NULL,
  alpha = NULL,
  beta = NULL,
  delta = NULL,
  gamma = NULL,
  theta = NULL,
  theta1 = NULL,
  theta2 = NULL
)
}
\arguments{
\item{process}{specifies the type of correlated noise process to simulate
and includes 'Noise_rho', 'ARFIMA_rho','ARFIMA_AR','AR_rho',
'Mixed_ARFIMA_ARFIMA','Mixed_ARFIMA_AR',and 'Mixed_ARFIMA_noise'.}

\item{n}{is a numeric value specifying the length of the time-series.}

\item{rho}{specifies the strength of the correlation with values -1 - 1.}

\item{d1}{is a numeric fractional difference parameter for x specifying long term 
memory.}

\item{d2}{is a numeric fractional difference parameter for x specifying long term 
memory.}

\item{d3}{is a numeric fractional difference parameter for y specifying long term 
memory.}

\item{d4}{is a numeric fractional difference parameter for y specifying long term 
memory.}

\item{alpha}{see Kristoufek (2013) for details.}

\item{beta}{see Kristoufek (2013) for details.}

\item{delta}{see Kristoufek (2013) for details.}

\item{gamma}{see Kristoufek (2013) for details.}

\item{theta}{see Kristoufek (2013) for details.}

\item{theta1}{see Kristoufek (2013) for details.}

\item{theta2}{see Kristoufek (2013) for details.}
}
\value{
The object returned is a matrix of length n with a time series (x,y)
in column 1 and 2.
}
\description{
Simulate various types of correlated noise processes.
}
\details{
This function includes multiple options simulating various
types of correlated noise processes including mixed-correlated ARFIMA
processes with power-law cross-correlations, These functions were originally
written by Ladislav Kristoufek and posted on his website. They go with
the paper presented in Kristoufek (2013). The 'process' argument specifies
the type of noise to be generated.
 \itemize{
  \item 'Noise_rho' - Generates two correlated noise series and requires
  arguments: n, rho.
  \item 'ARFIMA_rho' - Generates two ARFIMA processes with correlated
  innovations and requires arguments: n, d1, d2, rho.
  \item 'ARFIMA_AR'  - Generates ARFIMA and AR(1) processes with correlated
  innovations and requires arguments: n, d1, theta, rho.
  \item 'AR_rho' - Generates two AR(1) processes with correlated innovations
  and requires arguments: n, theta1, theta2, rho.
  \item 'Mixed_ARFIMA_ARFIMA' - Generates MC-ARFIMA process with long-range
  correlation and long-range cross-correlation (Kristoufec, 2013 Model 1) and
   requires arguments: alpha, beta, gamma, delta, n, d1, d2, d3, d4, rho.
  \item 'Mixed_ARFIMA_AR' - Generates MC-ARFIMA process with long-range
  correlation and short-range cross-correlation (Kristoufec, 2013 Model 2)
  and requires arguments: alpha, beta, gamma, delta, n, d1, d2, theta, rho.
  \item 'Mixed_ARFIMA_noise' - Generates MC-ARFIMA process with long-range
  correlation and simple correlation (Kristoufec, 2013 Model 3) and requires
  arguments: alpha, beta, gamma, delta, n, d1, d2, rho.
 }
}
\examples{
set.seed(987345757)

sim1 <- mc_ARFIMA(process='Mixed_ARFIMA_ARFIMA', alpha = 0.2,
beta = 1, gamma = 1, delta = 0.2, n = 10000, d1 = 0.4, d2 = 0.3,
d3 = 0.3, d4=0.4, rho=0.9)

plot(sim1[,1],type='l', ylab= "Signal Amplitude", xlab='Time',
main = "MC-ARFIMA with LRC and LRCC")

lines(sim1[,2], col='blue')

}
\references{
Kristoufek, L. (2013). Mixed-correlated ARFIMA processes for power-law
cross-correlations. Physica A: Statistical Mechanics and its Applications,
392(24), 6484-6493.
}
