% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessment_glance.R
\name{assessment_glance}
\alias{assessment_glance}
\title{Obtain tidy summary information for a floristic quality assessment}
\usage{
assessment_glance(data_set)
}
\arguments{
\item{data_set}{A data set downloaded from
\href{https://universalfqa.org/}{universalfqa.org} either manually or using
\code{\link[=download_assessment]{download_assessment()}}}
}
\value{
A data frame with 52 columns:
\itemize{
   \item Title (character)
   \item Date (date)
   \item Site Name (character)
   \item City (character)
   \item County (character)
   \item State (character)
   \item Country (character)
   \item FQA DB Region (character)
   \item FQA DB Publication Year (character)
   \item FQA DB Description (character)
   \item Custom FQA DB Name (character)
   \item Custom FQA DB Description (character)
   \item Practitioner (character)
   \item Latitude (character)
   \item Longitude (character)
   \item Weather Notes (character)
   \item Duration Notes (character)
   \item Community Type Notes (character)
   \item Other Notes (character)
   \item Private/Public (character)
   \item Total Mean C (numeric)
   \item Native Mean C (numeric)
   \item Total FQI: (numeric)
   \item Native FQI (numeric)
   \item Adjusted FQI (numeric)
   \item \% C value 0 (numeric)
   \item \% C value 1-3 (numeric)
   \item \% C value 4-6 (numeric)
   \item \% C value 7-10 (numeric)
   \item Native Tree Mean C (numeric)
   \item Native Shrub Mean C (numeric)
   \item Native Herbaceous Mean C (numeric)
   \item Total Species (numeric)
   \item Native Species (numeric)
   \item Non-native Species
   \item Mean Wetness (numeric)
   \item Native Mean Wetness (numeric)
   \item Tree (numeric)
   \item Shrub (numeric)
   \item Vine (numeric)
   \item Forb (numeric)
   \item Grass (numeric)
   \item Sedge (numeric)
   \item Rush (numeric)
   \item Fern (numeric)
   \item Bryophyte (numeric)
   \item Annual (numeric)
   \item Perennial (numeric)
   \item Biennial (numeric)
   \item Native Annual (numeric)
   \item Native Perennial (numeric)
   \item Native Biennial (numeric)
}
}
\description{
\code{assessment_glance()} tidies a floristic quality assessment data set
obtained from \href{https://universalfqa.org/}{universalfqa.org}.
}
\examples{
# While assessment_glance can be used with a .csv file downloaded manually
# from the universal FQA website, it is most typically used in combination
# with download_assessment().

edison <- download_assessment(25002)
assessment_glance(edison)

}
