% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pagination.R
\name{pag_indices_inner}
\alias{pag_indices_inner}
\title{Find Pagination Indices From Pagination Info Dataframe}
\usage{
pag_indices_inner(
  pagdf,
  rlpp,
  min_siblings,
  nosplitin = character(),
  verbose = FALSE
)
}
\arguments{
\item{pagdf}{data.frame. A pagination info data.frame as created by
either `make_rows_df` or `make_cols_df`.}

\item{rlpp}{numeric. Maximum number of \emph{row} lines per page (not including header materials), including (re)printed header and context rows}

\item{min_siblings}{numeric. Minimum sibling rows which must appear on either side of pagination row for a
mid-subtable split to be valid. Defaults to 2.}

\item{nosplitin}{character. List of names of sub-tables where page-breaks are not allowed, regardless of other
considerations. Defaults to none.}

\item{verbose}{logical(1). Should additional informative messages about the search for
pagination breaks be shown. Defaults to \code{FALSE}.}
}
\value{
A list containing the vector of row numbers, broken up by page
}
\description{
Pagination methods should typically call the `make_row_df` method
for their object and then call this function on the resulting
pagination info data.frame.
}
\examples{
mypgdf <- basic_pagdf(row.names(mtcars))

paginds <- pag_indices_inner(mypgdf, rlpp = 15, min_siblings = 0)
lapply(paginds, function(x) mtcars[x,])

}
