% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{forest_theme}
\alias{forest_theme}
\title{Forest plot default theme}
\usage{
forest_theme(
  base_size = 12,
  base_family = "",
  ci_pch = 15,
  ci_col = "black",
  ci_alpha = 1,
  ci_fill = NULL,
  ci_lty = 1,
  ci_lwd = 1,
  ci_Theight = NULL,
  legend_name = "Group",
  legend_position = "right",
  legend_value = "",
  xaxis_lwd = 0.6,
  xaxis_cex = 1,
  refline_lwd = 1,
  refline_lty = "dashed",
  refline_col = "grey20",
  vertline_lwd = 1,
  vertline_lty = "dashed",
  vertline_col = "grey20",
  summary_fill = "#4575b4",
  summary_col = "#4575b4",
  footnote_cex = 0.6,
  footnote_fontface = "plain",
  footnote_col = "black",
  title_just = c("left", "right", "center"),
  title_cex = 1.2,
  title_fontface = "bold",
  title_col = "black",
  title_fontfamily = base_family,
  arrow_type = c("open", "closed"),
  arrow_label_just = c("start", "end"),
  arrow_length = 0.05,
  arrow_lwd = xaxis_lwd,
  arrow_fill = "black",
  arrow_col = arrow_fill,
  arrow_cex = xaxis_cex,
  ...
)
}
\arguments{
\item{base_size}{The size of text}

\item{base_family}{The font family}

\item{ci_pch}{Shape of the point estimation. It will be reused if the
forest plot is grouped.}

\item{ci_col}{Color of the CI. A vector of color should be provided for
the grouped forest plot. An internal color set will be if only not.}

\item{ci_alpha}{Scalar value, alpha channel for transparency of point estimation.
A small vertical line will be added to indicate the point estimation if this
is not equals to 1.}

\item{ci_fill}{Color fill the point estimation. A vector of color should be
provided for the grouped forest plot. If this is \code{NULL} (default), the
value will inherit from \code{"ci_col"}. This is valid only if
\code{ci_pch} within 15:25.}

\item{ci_lty}{Line type of the CI. A vector of line type should be provided
for the grouped forest plot.}

\item{ci_lwd}{Line width of the CI. A vector of line type should be provided
for the grouped forest plot.}

\item{ci_Theight}{A unit specifying the height of the T end of CI. If set to
\code{NULL} (default), no T end will be drawn.}

\item{legend_name}{Title of the legend.}

\item{legend_position}{Position of the legend, \code{"right"}, \code{"top"},
\code{"bottom"} or \code{"none"} to suppress the legend.}

\item{legend_value}{Legend labels (expressions). A vector should be provided
for the grouped forest plot. A "Group 1" etc will be created if not a vector
for a grouped forest plot.}

\item{xaxis_lwd}{Line width for x-axis.}

\item{xaxis_cex}{Multiplier applied to font size for x-axis.}

\item{refline_lwd}{Line width for reference line.}

\item{refline_lty}{Line type for reference line.}

\item{refline_col}{Line color for the reference line.}

\item{vertline_lwd}{Line width for extra vertical line. A vector can be provided
for each vertical line, and the values will be recycled if no enough values are
given.}

\item{vertline_lty}{Line type for extra vertical line. Works same as \code{vertline_lwd}.}

\item{vertline_col}{Line color for the extra vertical line. Works same as \code{vertline_lwd}.}

\item{summary_fill}{Color for filling the summary diamond shape.}

\item{summary_col}{Color for borders of the summary diamond shape.}

\item{footnote_cex}{Multiplier applied to font size for footnote.}

\item{footnote_fontface}{The font face for footnote.}

\item{footnote_col}{Color of the footnote.}

\item{title_just}{The justification of the title, default is \code{'left'}.}

\item{title_cex}{Multiplier applied to font size for title.}

\item{title_fontface}{The font face for title, default is \code{'bold'}.}

\item{title_col}{Color of title.}

\item{title_fontfamily}{Font family of title.}

\item{arrow_type}{Type of the arrow below x-axis, see \code{\link[grid]{arrow}}.}

\item{arrow_label_just}{The justification of the arrow label relative to arrow. Control
the arrow label to align to the starting point of the arrow \code{"start"} (default) or
the ending point of the arrow \code{"end"}.}

\item{arrow_length}{The length of the arrow head, default is \code{0.05}.
See \code{\link[grid]{arrow}}.}

\item{arrow_lwd}{Line width of the arrow, same as \code{xaxis_lwd} by default.}

\item{arrow_fill}{Filling color of the arrow head, default is \code{"black"}.}

\item{arrow_col}{Line and text color of the arrow, same as \code{arrow_fill} by default.}

\item{arrow_cex}{Multiplier applied to font size for arrow label, same as \code{xaxis_cex} by default.}

\item{...}{Other parameters passed to table. See \code{\link[gridExtra]{tableGrob}}
for details.}
}
\value{
A list.
}
\description{
Default theme for the forest plot, but can pass other parameters. The
parameters will be passed to corresponding elements of the forest plot.

\itemize{
\item{\code{ci_*}}{Control the graphical parameters of confidence intervals}
\item{\code{legend_*}}{Control the graphical parameters of legend}
\item{\code{xaxis_*}}{Control the graphical parameters of x-axis}
\item{\code{refline_*}}{Control the graphical parameters of reference line}
\item{\code{vertline_*}}{Control the graphical parameters of vertical line}
\item{\code{summary_*}}{Control the graphical parameters of diamond shaped summary CI}
\item{\code{footnote_*}}{Control the graphical parameters of footnote}
\item{\code{title_*}}{Control the graphical parameters of title}
\item{\code{arrow_*}}{Control the graphical parameters of arrow}
}

See \code{\link[grid]{gpar}} for more details.
}
\seealso{
\code{\link[gridExtra]{tableGrob}} \code{\link{forest}} \code{\link[grid]{textGrob}}
\code{\link[grid]{gpar}} \code{\link[grid]{arrow}} \code{\link[grid]{segmentsGrob}}
\code{\link[grid]{linesGrob}} \code{\link[grid]{pointsGrob}} \code{\link[grid]{legendGrob}}
}
