% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_clutter.R
\name{fit_clutter}
\alias{fit_clutter}
\title{Fit the Clutter model for growth and yield}
\usage{
fit_clutter(df, age, dh, basal_area, volume, site, plot, .groups = NA,
  model = "full", keep_model = FALSE)
}
\arguments{
\item{df}{A data frame.}

\item{age}{Quoted name for the age variable.}

\item{dh}{Quoted name for the dominant height variable.}

\item{basal_area}{Quoted name for the basal area variable.}

\item{volume}{Quoted name for the volume area variable.}

\item{site}{Quoted name for the site variable.}

\item{plot}{Quoted name for the plot variable.}

\item{.groups}{Optional argument. Quoted name(s) of grouping variables used to fit multiple regressions, one for each level of the provided variable(s). Default \code{NA}.}

\item{model}{Character variable for the type of the model fitted. If \code{"full"}, the full model will be used. if \code{"mod"}, a modified model will be fitted, where the X3 variable is excluded from the regression. Default: \code{full}.}

\item{keep_model}{If \code{TRUE} a variable with the regression model will be kept in the data frame. Default: \code{FALSE}.}
}
\value{
A data frame with the regression coefficients.
}
\description{
Fit the Clutter model for growth and yield using the two stage least squares method (2SLS).
}
\examples{

library(forestmangr)
data("exfm17")
exfm17

# To fit the Clutter model we just need to define the data, and age, dominant height,
# basal area, volume, site and plot variables:
fit_clutter(exfm17, "age", "DH", "B", "V", "S", "plot")

# To fit the alternate model (without a1) just use model="mod":
fit_clutter(exfm17, "age", "DH", "B", "V", "S", "plot",model="mod")

# To keep the regression model, use keep_model=TRUE:
fit_clutter(exfm17, "age", "DH", "B", "V", "S", "plot", keep_model=TRUE) 
             
}
\references{
Clutter, J. L. (1963) Compatible Growth For Loblolly by the Southeastern, Forest Science, 9(3), pp. 354–371.
Sullivan, A. D. and Clutter, J. L. (1972) A Simultaneous Growth and Yield for Loblolly Pine, Forest Science, 18(1), pp. 76–86.
Campos, J. C. C. and Leite, H. G. (2017) Mensuracao Florestal: Perguntas e Respostas. 5a. Vicosa: UFV.
}
\seealso{
other sampling functions: 
  \code{\link{est_clutter}} for estimating the Clutter growth and yield model variables, and
  \code{\link{classify_site}} for classifying data according to site.
}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
\keyword{2SLS}
\keyword{Clutter,}
