% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{red_peaks_100}
\alias{red_peaks_100}
\title{Reduce Peaks}
\usage{
red_peaks_100(
  df,
  plot.to.screen = FALSE,
  path.data = NULL,
  path.plots = NULL,
  show.progress = FALSE
)
}
\arguments{
\item{df}{The resulting tibble of the function \code{rescale_peaks()}. See \code{?rescale_peaks} for more details.
The columns \code{measurement} and \code{force.norm} must be present.}

\item{plot.to.screen}{A logical value indicating if results should be
plotted in the current R plot device. Default: \code{FALSE}.}

\item{path.data}{A string character defining where to save the results.
If \code{NULL}, data will not be saved to disk. Default: \code{NULL}.}

\item{path.plots}{A string character defining where to save result plots.
If \code{NULL}, plots will not be saved to disk. Default: \code{NULL}.}

\item{show.progress}{A logical value indicating if progress should be
printed to the console. Default: \code{FALSE}.}
}
\value{
This function returns a tibble with a similar format as \code{df}, but the columns \code{t}, \code{force}, \code{t.norm} and \code{force.norm} are replaced
by the columns \code{index}, ranging from 1 to 100, and \code{force.norm.100}, containing the rescaled force data ranging from 0 to 1. Since the time series
has been reduced to 100 observations, this tibble will always contain 100 rows per peak.
}
\description{
Reduces curves to 100 observations per peak.
}
\section{\code{df} needs to contain the following columns:}{
\tabular{ccc}{
   \strong{\code{force}} \tab \strong{\code{measurement}} \tab \strong{\code{peak}} \cr
   \code{force.norm.norm.1} \tab \code{measurement.1} \tab \code{peak.1} \cr
   \code{...} \tab \code{...} \tab \code{...} \cr
   \code{force.norm.n} \tab \code{measurement.m} \tab \code{peak.n} \cr
}
}

\examples{
# Using the forceR::df.all.200.tax dataset:
peaks.df.norm.100 <- red_peaks_100(df = forceR::peaks.df.norm,
                                   path.data = NULL,
                                   path.plots = NULL,
                                   show.progress = FALSE)

peaks.df.norm.100

}
