% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{join}
\alias{join}
\title{join an mpm-estimated behavioural index to ssm-predicted locations}
\usage{
join(ssm, mpm, what.ssm = "predicted", as_sf = TRUE)
}
\arguments{
\item{ssm}{a \code{foieGras} ssm fitted model object}

\item{mpm}{a \code{foieGras} mpm fitted model object}

\item{what.ssm}{specifies whether ssm \code{predicted} or \code{fitted} values are to be extracted}

\item{as_sf}{logical; if FALSE then return a tibble with un-projected lonlat
coordinates, otherwise return an sf tibble}
}
\value{
a single tbl with all individuals
}
\description{
\code{join()} joins ssm-predicted locations and mpm-estimated behavioural index into a single tibble. If the ssm-predicted tibble is a projected sf object then the output of join will also be an sf object (default). This can be avoided by using \code{as_sf = FALSE}.
}
\examples{
## load example foieGras fit objects (to save time)
## generate a fG_ssm fit object
xs <- fit_ssm(sese2, spdf=FALSE, model = "rw", time.step=72, 
control = ssm_control(se = FALSE, verbose = 0))
data(xm)

## join predicted values as an un-projected tibble
xsm <- join(xs, xm, as_sf = FALSE)
xsm
}
