% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfilter.R
\name{sfilter}
\alias{sfilter}
\title{fit the state-space model to data after passing through \code{prefilter}}
\usage{
sfilter(
  x,
  model = c("rw", "crw"),
  time.step = 6,
  scale = FALSE,
  parameters = NULL,
  map = NULL,
  fit.to.subset = TRUE,
  control = ssm_control(),
  inner.control = NULL
)
}
\arguments{
\item{x}{Argos data passed through prefilter()}

\item{model}{specify which SSM is to be fit: "rw" or "crw"}

\item{time.step}{the regular time interval, in hours, to predict to.
Alternatively, a vector of prediction times, possibly not regular, must be
specified as a data.frame with id and POSIXt dates.}

\item{scale}{scale location data for more efficient optimization.}

\item{parameters}{a list of initial values for all model parameters and
unobserved states, default is to let sfilter specify these. Only play with
this if you know what you are doing...}

\item{map}{a named list of parameters as factors that are to be fixed during estimation, e.g., list(psi = factor(NA))}

\item{fit.to.subset}{fit the SSM to the data subset determined by prefilter
(default is TRUE)}

\item{control}{list of control parameters for the outer optimization (see \code{ssm_control} for details)}

\item{inner.control}{list of control settings for the inner optimization
(see ?TMB::MakeADFUN for additional details)}

\item{verbose}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} use ssm_control(verbose = 1) instead, see \code{ssm_control} for details}

\item{optim}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} use ssm_control(optim = "optim") instead, see \code{ssm_control} for details}

\item{optMeth}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} use ssm_control(method = "L-BFGS-B") instead, see \code{ssm_control} for details}

\item{lpsi}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} use ssm_control(lower = list(lpsi = -Inf)) instead, see \code{ssm_control} for details}
}
\description{
generates initial values for model parameters and unobserved states;
structures data and initial values for C++ \code{TMB} template;
fits state-space model; minimizes the joint log-likelihood via the selected
optimizer (\code{nlminb} or \code{optim}); structures and passes output
object to \code{fit_ssm}
}
\details{
called by \code{fit_ssm}, not intended for general use. \code{sfilter} can only fit to an
individual track, use \code{fit_ssm} to fit to multiple tracks (see ?fit_ssm).
}
\keyword{internal}
