% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_fmriqa.R
\name{run_fmriqa}
\alias{run_fmriqa}
\title{Run fMRI quality assurance procedure on a NIfTI data file}
\usage{
run_fmriqa(data_file = NULL, roi_width = 21, slice_num = NULL, skip = 2,
  tr = NULL, poly_det_ord = 3, spike_detect = FALSE, x_pos = NULL,
  y_pos = NULL, plot_title = NULL, last_vol = NULL, gen_png = TRUE,
  gen_res_csv = TRUE, gen_pdf = FALSE, gen_spec_csv = FALSE,
  png_fname = NULL, res_fname = NULL, pdf_fname = NULL,
  spec_fname = NULL, verbose = TRUE)
}
\arguments{
\item{data_file}{input data in nifti format, a file chooser will open if not set}

\item{roi_width}{roi analysis region in pixels (default=21)}

\item{slice_num}{slice number for analysis (default=middle slice)}

\item{skip}{number of initial volumes to exclude from the analysis (default=2)}

\item{tr}{override the TR detected from data (seconds)}

\item{poly_det_ord}{polynomial order used for detrending (default=3)}

\item{spike_detect}{generate k-space spike-detection plot (default=FALSE)}

\item{x_pos}{x position of ROI (default=center of gravity)}

\item{y_pos}{y position of ROI (default=center of gravity)}

\item{plot_title}{add a title to the png and pdf plots}

\item{last_vol}{last volume number to use in the analysis}

\item{gen_png}{output png plot (default=TRUE)}

\item{gen_res_csv}{output csv results (default=TRUE)}

\item{gen_pdf}{output pdf plot (default=FALSE)}

\item{gen_spec_csv}{output csv of spectral points (default=FALSE)}

\item{png_fname}{png plot filename}

\item{res_fname}{csv results filename}

\item{pdf_fname}{pdf plot filename}

\item{spec_fname}{csv spectral data filename}

\item{verbose}{provide text output while running (default=TRUE)}
}
\value{
dataframe of QA metrics
}
\description{
Run fMRI quality assurance procedure on a NIfTI data file
}
\examples{
fname <- system.file("extdata", "qa_data.nii.gz", package = "fmriqa")
res <- run_fmriqa(data_file = fname, gen_png = FALSE, gen_res_csv = FALSE, tr = 3)

}
