% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-fmexample.R
\docType{data}
\name{fmexample}
\alias{fmexample}
\title{Example mesh data}
\format{
The data is a list containing these elements:
\describe{
\item{\code{loc}:}{ A \code{matrix} of points.}
\item{\code{loc_sf}:}{ An \code{sfc} version of \code{loc}.}
\item{\code{boundary_fm}:}{ A \code{fm_segm_list} of two \code{fm_segm} objects used in
the mesh construction.}
\item{\code{boundary_sf}:}{ An \code{sfc} list version of \code{boundary}.}
\item{\code{mesh}:}{ An \code{\link[=fm_mesh_2d]{fm_mesh_2d()}} object.}
}
}
\source{
Generated by \code{data-raw/fmexample.R}.
}
\usage{
fmexample
}
\description{
This is an example data set used for \code{fmesher} package examples.
}
\examples{
if (require(ggplot2, quietly = TRUE)) {
  ggplot() +
    geom_sf(data = fm_as_sfc(fmexample$mesh)) +
    geom_sf(data = fmexample$boundary_sf[[1]], fill = "red", alpha = 0.5)
}
}
\seealso{
\code{\link[=fmexample_sp]{fmexample_sp()}}
}
\keyword{datasets}
