# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Compute sparse matrix inverse
#'
#' @description
#' Requires RcppEigen which is not compiled in by default. Enable with
#' `PKG_CPPFLAGS=-DFMESHER_WITH_EIGEN` in `src/Makevars` and add `RcppEigen`
#' to the `DESCRIPTION` `LinkingTo` field.
#'
#' @param AA A sparse matrix
#' @keywords internal
fmesher_qinv <- function(AA) {
    .Call(`_fmesher_fmesher_qinv`, AA)
}

#' @title Globe points
#'
#' @description
#' Create points on a globe
#'
#' @param globe integer; the number of edge subdivision segments, 1 or higher.
#' @returns A matrix of points on a unit radius globe
#' @examples
#' fmesher_globe_points(1)
#' @export
fmesher_globe_points <- function(globe) {
    .Call(`_fmesher_fmesher_globe_points`, globe)
}

#' @title Refined Constrained Delaunay Triangulation
#'
#' @description
#' (...)
#'
#' @param options list of triangulation options
#' @param loc numeric matrix; initial points to include
#' @param tv 3-column integer matrix with 0-based vertex indices for each triangle
#' @param boundary 2-column integer matrix with 0-based vertex indices for each
#' boundary edge constraint
#' @param interior 2-column integer matrix with 0-based vertex indices for each
#' interior edge constraint
#' @param boundary_grp integer vector with group labels
#' @param interior_grp integer vector with group labels
#' @examples
#' m <- fmesher_rcdt(list(cet_margin = 1), matrix(0, 1, 2))
#' @returns A list of information objects for a generated triangulation
#' @export
fmesher_rcdt <- function(options, loc, tv = NULL, boundary = NULL, interior = NULL, boundary_grp = NULL, interior_grp = NULL) {
    .Call(`_fmesher_fmesher_rcdt`, options, loc, tv, boundary, interior, boundary_grp, interior_grp)
}

#' @title Barycentric coordinate computation
#'
#' @description
#' Locate points and compute triangular barycentric coordinates
#'
#' @param loc numeric matrix; coordinates of points to locate in the mesh
#' @param mesh_loc numeric matrix; mesh vertex coordinates
#' @param mesh_tv 3-column integer matrix with 0-based vertex indices for each triangle
#' @param options list of triangulation options
#' @examples
#' m <- fmesher_rcdt(list(cet_margin = 1), matrix(0, 1, 2))
#' b <- fmesher_bary(m$s,
#'                   m$tv,
#'                   matrix(c(0.5, 0.5), 1, 2),
#'                   list())
#' @returns A list with vector `t` and matrix `bary`
#' @export
fmesher_bary <- function(mesh_loc, mesh_tv, loc, options) {
    .Call(`_fmesher_fmesher_bary`, mesh_loc, mesh_tv, loc, options)
}

#' @title Rotationally invariant spherical B-splines
#'
#' @description
#' Compute rotationally invariant spherical B-splines on the unit sphere
#'
#' @param loc numeric vector/matrix; coordinates of points to locate in the mesh,
#' only the z-coordinates are used (`sin(latitude)`)
#' @param n The number of basis functions
#' @param degree The polynomial basis degree
#' @param uniform logical; If `TRUE`, the knots are spaced uniformly by latitude,
#' if `FALSE`, the knots are spaced uniformly by `sin(latitude)`
#' @rdname fmesher_spherical_bsplines
#' @examples
#' m <- fm_rcdt_2d(globe = 1)
#' fmesher_spherical_bsplines(m$loc, n = 3, degree = 2, uniform = FALSE)
#' fmesher_spherical_bsplines1(m$loc[, 3], n = 3, degree = 2, uniform = FALSE)
#' @export
#' @keywords internal
#' @returns A matrix of evaluated b-spline basis functions
fmesher_spherical_bsplines1 <- function(loc, n, degree, uniform) {
    .Call(`_fmesher_fmesher_spherical_bsplines1`, loc, n, degree, uniform)
}

#' @rdname fmesher_spherical_bsplines
#' @export
fmesher_spherical_bsplines <- function(loc, n, degree, uniform) {
    .Call(`_fmesher_fmesher_spherical_bsplines`, loc, n, degree, uniform)
}

#' @title Finite element matrix computation
#'
#' @description
#' Construct finite element structure matrices
#'
#' @param mesh_loc numeric matrix; mesh vertex coordinates
#' @param mesh_tv 3-column integer matrix with 0-based vertex indices for each triangle
#' @param fem_order_max integer; the highest operator order to compute
#' @param aniso If non-NULL, a `list(gamma, v)`. Calculates anisotropic structure
#' matrices (in addition to the regular) for \eqn{\gamma}{gamma} and \eqn{v}{v} for
#' an anisotropic operator \eqn{\nabla\cdot H \nabla}{div H grad}, where
#' \eqn{H=\gamma I + v v^\top}{H = gamma I + v v'}.
#' Currently (2023-08-05) the fields need to be given per vertex.
#' @param options list of triangulation options (`sphere_tolerance`)
#' @examples
#' m <- fmesher_rcdt(list(cet_margin = 1), matrix(0, 1, 2))
#' b <- fmesher_fem(m$s, m$tv, fem_order_max = 2, aniso = NULL, options = list())
#' @returns A list of matrices
#' @export
fmesher_fem <- function(mesh_loc, mesh_tv, fem_order_max, aniso, options) {
    .Call(`_fmesher_fmesher_fem`, mesh_loc, mesh_tv, fem_order_max, aniso, options)
}

#' @title Split lines at triangle edges
#'
#' @description
#' Split a sequence of line segments at triangle edges
#'
#' @param mesh_loc numeric matrix; mesh vertex coordinates
#' @param mesh_tv 3-column integer matrix with 0-based vertex indices for each triangle
#' @param loc numeric coordinate matrix
#' @param idx 2-column integer matrix
#' @param options list of triangulation options (`sphere_tolerance`)
#' @export
#' @returns A list of line splitting information objects
#' @seealso [fm_split_lines()]
#' @examples
#' mesh <- fm_mesh_2d(
#'   boundary = fm_segm(rbind(c(0,0), c(1,0), c(1,1), c(0, 1)), is.bnd = TRUE)
#' )
#' splitter <- fm_segm(rbind(c(0.8, 0.2), c(0.2, 0.8)))
#' segm_split <- fm_split_lines(mesh, splitter)
fmesher_split_lines <- function(mesh_loc, mesh_tv, loc, idx, options) {
    .Call(`_fmesher_fmesher_split_lines`, mesh_loc, mesh_tv, loc, idx, options)
}

#' @title Subdivide triangles
#'
#' @description
#' Subdivide a mesh with congruent and anti-congruent subtriangles
#'
#' @param mesh_loc numeric matrix; mesh vertex coordinates
#' @param mesh_tv 3-column integer matrix with 0-based vertex indices for each triangle
#' @param mesh_boundary 2-column integer matrix with 0-based vertex indices for
#' boundary constraints, currently ignored
#' @param mesh_interior 2-column integer matrix with 0-based vertex indices for
#' interior constraints, currently ignored
#' @param subdivisions integer; number of new points along each edge.
#' @param options list of triangulation options (`sphere_tolerance`)
#' @returns A list of new `loc` and `tv` information
#' @keywords internal
#' @seealso [fm_subdivide()]
#' @examples
#' mesh <- fm_mesh_2d(
#'   boundary = fm_segm(rbind(c(0,0), c(1,0), c(1,1), c(0, 1)), is.bnd = TRUE)
#' )
#' new_mesh <- fm_subdivide(mesh, n = 3)
#' plot(new_mesh, edge.color = 2)
#' plot(mesh, add = TRUE, edge.color = 1)
fmesher_subdivide <- function(mesh_loc, mesh_tv, mesh_boundary, mesh_interior, subdivisions, options) {
    .Call(`_fmesher_fmesher_subdivide`, mesh_loc, mesh_tv, mesh_boundary, mesh_interior, subdivisions, options)
}

