% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faststress.R
\name{faststress}
\alias{faststress}
\title{Fast Stress Function}
\usage{
faststress(
  lower = NULL,
  delta = NULL,
  data = NULL,
  w = NULL,
  z = NULL,
  d = NULL
)
}
\arguments{
\item{lower}{an n x (n - 1 ) / 2 vector containing lower triangular part of dissimilarity matrix.}

\item{delta}{an n by n square hollow matrix containing dissimilarities.}

\item{data}{an n by m multivariate data matrix.}

\item{w}{an identical sized matrix containing non-negative weights (all ones when omitted).}

\item{z}{n by p matrix with coordinates.}

\item{d}{distances between the rows of z, an n by n square hollow matrix containing Euclidean distances.}
}
\value{
n.stress normalized stress value
}
\description{
\code{faststress} calculates value for normalized stress with different input parameters.
Distances d are optimally scaled.
}
\examples{
n <- 100
m <- 10
data <- matrix( runif( n * m ), n, m )
d <- dist( data )
lower <- as.vector( d )
delta <- as.matrix( d )
p <- 2
zinit <- matrix( runif( n * p ), n, p )
r <- fastmds( delta = delta, p = p, z = zinit )
faststress( data = data, z = r$coordinates )
faststress( data = data, d = r$distances )
faststress( delta = delta, z = r$coordinates )
faststress( data = data, d = r$distances )
faststress( lower = lower, z = r$coordinates )
faststress( lower = lower, d = r$distances )

}
\author{
Frank M.T.A. Busing
}
