% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastermds.R
\name{fastermds}
\alias{fastermds}
\title{Stochastic Iterative Majorization Multidimensional Scaling Function}
\usage{
fastermds(
  delta = NULL,
  lower = NULL,
  data = NULL,
  w = NULL,
  p = 2,
  z = NULL,
  fixed = NULL,
  linear = FALSE,
  boundary = NULL,
  interval = FALSE,
  NCYCLES = 32,
  MINRATE = 0.01,
  error.check = FALSE
)
}
\arguments{
\item{delta}{dissimilarity matrix, non-negative, square, and hollow.}

\item{lower}{lower triangular part of dissimilarity matrix.}

\item{data}{multivariate data matrix.}

\item{w}{non-negative weights per dissimilarity for delta and lower, and per object for data}

\item{p}{dimensionality (default = 2).}

\item{z}{n by p matrix with initial coordinates.}

\item{fixed}{n by p matrix with booleans indicating free (FALSE) or fixed (TRUE) coordinates.}

\item{linear}{boolean indicating whether linear is used.}

\item{boundary}{boundary value for local mds.}

\item{interval}{interval measurements for interval mds, requires delta data format.}

\item{NCYCLES}{number of cycles taken by the algorithm (default = 32).}

\item{MINRATE}{criterion rate of convergence (default = 0.01).}

\item{error.check}{extensive validity check input parameters (default = FALSE).}
}
\value{
n by p matrix with final coordinates.
}
\description{
\code{fastermds} performs multidimensional scaling using a stochastic iterative majorization algorithm.
The data are either dissimilarities (full or only lower triangular part) or multivariate data.
The dissimilarities and the weights may not contain negative values.
The configuration is either unrestricted or (partly) fixed.
Local multidimensional scaling is performed when a boundary is provided.
Interval multidimensional scaling is performed with a full dissimilarity matrix,
using the lower triangular part for the lower bound and the upper triangular part for the upper bound.
}
\details{
One of the following three data formats need to be specified:
}
\examples{
n <- 1000
m <- 10
delta <- as.matrix( dist( matrix( runif( n * m ), n, m ) ) )
p <- 2
zinit <- matrix( runif( n * p ), n, p )
r <- fastermds( delta = delta, p = p, z = zinit, error.check = TRUE )
head( r )

}
\references{
Agrafiotis, and others, and Busing
}
\author{
Frank M.T.A. Busing
}
