% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_shp.R
\name{export_shp}
\alias{export_shp}
\title{Write shapefiles}
\usage{
export_shp(obj, pathshp, FUN = rgdal::writeOGR, dsnlayerbind = F,
  data_source = flyio_get_datasource(),
  bucket = flyio_get_bucket(data_source), dir = flyio_get_dir(),
  delete_file = TRUE, ...)
}
\arguments{
\item{obj}{R object to be written}

\item{pathshp}{the path of the shapefile, which may or may not include the extension}

\item{FUN}{the function using which the file is to be read}

\item{dsnlayerbind}{if the FUN needs dsn and layer binded or not}

\item{data_source}{the name of the data source, if not set globally. s3, gcs or local}

\item{bucket}{the name of the bucket, if not set globally}

\item{dir}{the directory to store intermediate files}

\item{delete_file}{logical. to delete the file to be uploaded}

\item{...}{other parameters for the FUN function defined above}
}
\value{
output of the FUN function if any
}
\description{
Write shapefiles
}
\examples{
\dontrun{
# Save shapefile on Google Cloud
flyio_set_datasource("gcs")
flyio_set_bucket("your-bucket-name")
export_shp(your-shp, "your-shp.shp", driver = "ESRI Shapefile", overwrite = T, dir = tempdir())
}
}
