% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc_draw.R
\name{fc_draw}
\alias{fc_draw}
\title{fc_draw}
\usage{
fc_draw(
  object,
  arrow_angle = 30,
  arrow_length = grid::unit(0.1, "inches"),
  arrow_ends = "last",
  arrow_type = "closed",
  title = NULL,
  title_x = 0.5,
  title_y = 0.9,
  title_color = "black",
  title_fs = 15,
  title_fface = 2,
  title_ffamily = NULL
)
}
\arguments{
\item{object}{fc object that we want to draw.}

\item{arrow_angle}{The angle of the arrow head in degrees, as in `arrow`.}

\item{arrow_length}{A unit specifying the length of the arrow head (from tip to base), as in `arrow`.}

\item{arrow_ends}{One of "last", "first", or "both", indicating which ends of the line to draw arrow heads, as in `arrow`.}

\item{arrow_type}{One of "open" or "closed" indicating whether the arrow head should be a closed triangle, as in `arrow`.}

\item{title}{The title of the flowchart. Default is NULL (no title).}

\item{title_x}{x coordinate for the title. Default is 0.5.}

\item{title_y}{y coordinate for the title. Default is 0.9.}

\item{title_color}{Color of the title. It is black by default. See the `col` parameter for \code{\link{gpar}}.}

\item{title_fs}{Font size of the title. It is 15 by default. See the `fontsize` parameter for \code{\link{gpar}}.}

\item{title_fface}{Font face of the title. It is 2 by default. See the `fontface` parameter for \code{\link{gpar}}.}

\item{title_ffamily}{Changes the font family of the title. Default is NA. See the `fontfamily` parameter for \code{\link{gpar}}.}
}
\value{
Invisibly returns the same object that has been given to the function, with the given arguments to draw the flowchart stored in the attributes.
}
\description{
This function allows to draw the flowchart from a fc object.
}
\examples{
safo |>
  as_fc(label = "Patients assessed for eligibility") |>
  fc_filter(!is.na(group), label = "Randomized", show_exc = TRUE) |>
  fc_split(group) |>
  fc_filter(itt == "Yes", label = "Included in ITT") |>
  fc_filter(pp == "Yes", label = "Included in PP") |>
  fc_draw()

}
