% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_flights.R
\name{read_flights}
\alias{read_flights}
\title{Download flight data from Brazil}
\usage{
read_flights(
  date = 202001,
  type = "basica",
  showProgress = TRUE,
  select = NULL
)
}
\arguments{
\item{date}{Numeric. Date of the data in the format \code{yyyymm}. Defaults to
\code{202001}. To download the data for all months in a year, the user
can pass a 4-digit year input \code{yyyy}.}

\item{type}{String. Whether the data set should be of the type \code{basica}
(flight stage, the default) or \code{combinada} (On flight origin and
destination - OFOD).}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress.}

\item{select}{A vector of column names or numbers to keep, drop the rest. The
order that the columns are specified determines the order of the
columns in the result.}
}
\value{
A \verb{"data.table" "data.frame"} object. All columns are returned with
\code{class} of type \code{"character"}.
}
\description{
Download flight data from Brazil’s Civil Aviation Agency (ANAC). The data
includes detailed information on every international flight to and from Brazil,
as well as domestic flights within the country. The data include flight-level
information of airports of origin and destination, flight duration, aircraft
type, payload, and the number of passengers, and several other variables. A
description of all variables included in the data is available at \url{https://www.gov.br/anac/pt-br/assuntos/regulados/empresas-aereas/Instrucoes-para-a-elaboracao-e-apresentacao-das-demonstracoes-contabeis/descricao-de-variaveis}.
}
\examples{
\dontrun{ if (interactive()) {
# Read flights data
f201506 <- read_flights(date = 201506)

f2015 <- read_flights(date = 2015)
}}
}
\seealso{
Other download flight data: 
\code{\link{read_aircrafts}()}
}
\concept{download flight data}
