% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/body_add_flextable.R
\name{body_add_flextable}
\alias{body_add_flextable}
\title{add flextable into a Word document}
\usage{
body_add_flextable(x, value, align = "center", pos = "after")
}
\arguments{
\item{x}{an rdocx object}

\item{value}{\code{flextable} object}

\item{align}{left (default), center or right.}

\item{pos}{where to add the flextable relative to the cursor,
one of "after", "before", "on" (end of line).}
}
\description{
add a flextable into a Word document.
}
\examples{
library(officer)
ft <- flextable(head(mtcars))
ft <- theme_zebra(ft)
\donttest{ft <- autofit(ft)}
doc <- read_docx()
doc <- body_add_flextable(doc, value = ft)
\donttest{print(doc, target = "test.docx")}
}
