% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_S3_plots.R
\name{plot.explorer}
\alias{plot.explorer}
\title{Plot an object of class \code{explorer}}
\usage{
\method{plot}{explorer}(
  x,
  type = "var_by_x",
  label_size = 4,
  signif = FALSE,
  method = "pearson",
  filter_var = NULL,
  id = NULL,
  n_row = NULL,
  n_col = NULL,
  base_size = 13,
  return_gg = FALSE,
  add_avg = FALSE,
  ...
)
}
\arguments{
\item{x}{An object inheriting from class \code{explorer}, resulting from executing the function \code{explorer()}.}

\item{type}{Character string or number specifying the type of plot to generate. Available options are:
\describe{
  \item{\code{"var_by_x" or 1}}{Plots correlations between variables over x (default).}
  \item{\code{"x_by_var" or 2}}{Plots correlations between x points for each variable (y).}
  \item{\code{"evolution" or 3}}{Plot the evolution of the variables (y) over x.}
  \item{\code{"xy" or 4}}{Scatterplot (x, y)}
}}

\item{label_size}{Numeric. Size of the labels in the plot. Default is 4. Only works with type 1 and 2.}

\item{signif}{Logical. If \code{TRUE}, adds p-values to the correlation plot labels. Default is \code{FALSE}. Only works with type 1 and 2.}

\item{method}{Character string specifying the method for correlation calculation. Available options are \code{"pearson"} (default), \code{"spearman"}, and \code{"kendall"}. Only works with type 1 and 2.}

\item{filter_var}{Character vector specifying the variables to exclude from the plot.}

\item{id}{Optional unique identifier to filter the evolution type of plot. Default is \code{NULL}. Only works with type 3.}

\item{n_row}{Integer specifying the number of rows to use in \code{facet_wrap()}. Default is \code{NULL}. Only works with type 1 and 2.}

\item{n_col}{Integer specifying the number of columns to use in \code{facet_wrap()}. Default is \code{NULL}. Only works with type 1 and 2.}

\item{base_size}{Numeric. Base font size for the plot. Default is 13.}

\item{return_gg}{Logical. If \code{TRUE}, returns the ggplot object instead of printing it. Default is \code{FALSE}.}

\item{add_avg}{Logical. If \code{TRUE}, returns evolution plot with the average trend across groups. Default is \code{FALSE}.}

\item{...}{Further graphical parameters for future improvements.}
}
\value{
A ggplot object and an invisible data.frame containing the correlation table when \code{type} is \code{"var_by_x"} or \code{"x_by_var"}.
}
\description{
Creates various plots for an object of class \code{explorer}.
Depending on the specified type, the function can generate plots that show correlations between variables over x, correlations between x values for each variable, or the evolution of variables over x.
}
\examples{
library(flexFitR)
data(dt_potato)
results <- explorer(dt_potato, x = DAP, y = c(Canopy, GLI), id = Plot)
table <- plot(results, label_size = 4, signif = TRUE, n_row = 2)
table
plot(results, type = "x_by_var", label_size = 4, signif = TRUE)
}
