% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviates.R
\name{deviate_wave}
\alias{deviate_wave}
\title{Return a deviate vector with a wave-shape trend}
\usage{
deviate_wave(k)
}
\arguments{
\item{k}{an integer. The number of components.}
}
\value{
An \code{rkhist} object.
}
\description{
This function returns a deviate vector with the right properties to test the
presence of a deviate to flatness with a sine trend in a rank histogram, as
introduced in (Zamo et al. 2021) or (Zamo, 2016).
}
\details{
Although the deviate vector is not a rank histogram, this function returns
an \code{rkhist} object for the sake of simplicity. This allows for instance
to plot the vector.
}
\references{
\itemize{
\item Jolliffe, Ian T., and Cristina Primo. "Evaluating rank histograms using
decompositions of the chi-square test statistic." \emph{Monthly Weather
Review} 136.6 (2008): 2133-2139. doi:https://doi.org/10.1175/2007MWR2219.1
\item Zamo, Michaël, Liliane Bel, and Olivier Mestre. "Sequential aggregation of
probabilistic forecasts—application to wind speed ensemble forecasts."
Journal of the Royal Statistical Society: Series C (Applied Statistics) 70.1
(2021): 202-225. doi:https://doi.org/10.1111/rssc.12455
\item Zamo, Michaël. Statistical Post-processing of Deterministic and Ensemble
Wind Speed Forecasts on a Grid. Diss. Université Paris-Saclay (ComUE), 2016.}
}
