% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_breakdown.R
\name{light_breakdown}
\alias{light_breakdown}
\alias{light_breakdown.default}
\alias{light_breakdown.flashlight}
\alias{light_breakdown.multiflashlight}
\title{Variable Contribution Breakdown for Single Observation}
\usage{
light_breakdown(x, ...)

\method{light_breakdown}{default}(x, ...)

\method{light_breakdown}{flashlight}(
  x,
  new_obs,
  data = x$data,
  by = x$by,
  v = NULL,
  visit_strategy = c("importance", "permutation", "v"),
  n_max = Inf,
  n_perm = 20,
  seed = NULL,
  use_linkinv = FALSE,
  after_name = "after",
  before_name = "before",
  label_name = "label",
  variable_name = "variable",
  step_name = "step",
  description_name = "description",
  description = TRUE,
  digits = 3,
  ...
)

\method{light_breakdown}{multiflashlight}(x, ...)
}
\arguments{
\item{x}{An object of class \code{flashlight} or \code{multiflashlight}.}

\item{...}{Further arguments passed to \code{prettyNum} to format numbers in description text.}

\item{new_obs}{One single new observation to calculate variable attribution for. Needs to be a \code{data.frame} of same structure as \code{data}.}

\item{data}{An optional \code{data.frame}.}

\item{by}{An optional vector of column names used to filter \code{data} for rows with equal values in "by" variables as \code{new_obs}.}

\item{v}{Vector of variables to assess contribution for. Defaults to all except those specified by "y", "w" and "by".}

\item{visit_strategy}{In what sequence should variables be visited? By "importance", by \code{n_perm} "permutation" or as "v" (see Details).}

\item{n_max}{Maximum number of rows in \code{data} to consider in the reference data. Set to lower value if \code{data} is large.}

\item{n_perm}{Number of permutations of random visit sequences. Only used if \code{visit_strategy = "permutation"}.}

\item{seed}{An integer random seed used to shuffle rows if \code{n_max} is smaller than the number of rows in \code{data}.}

\item{use_linkinv}{Should retransformation function be applied? Default is \code{FALSE}.}

\item{after_name}{Column name in resulting \code{data} containing prediction after the step in \code{step_name}. Defaults to "after".}

\item{before_name}{Column name in resulting \code{data} containing prediction before the step in \code{step_name}. Defaults to "before".}

\item{label_name}{Column name in resulting \code{data} containing the label of the flashlight. Defaults to "label".}

\item{variable_name}{Column name in resulting \code{data} containing the variable names. Defaults to "variable".}

\item{step_name}{Column name in resulting \code{data} containing the step of the prediction process. Defaults to "step".}

\item{description_name}{Column name in resulting \code{data} containing the description text to be visualized. Defaults to "description".}

\item{description}{Should descriptions be added? Default is \code{TRUE}.}

\item{digits}{Passed to \code{prettyNum} to format numbers in description text.}
}
\value{
An object of class \code{light_breakdown}, \code{light} (and a list) with the following elements.
\itemize{
  \item \code{data} A tibble with results. Can be used to build fully customized visualizations.
  \item \code{by} Same as input \code{by}.
  \item \code{after_name} Same as input \code{after_name}.
  \item \code{before_name} Same as input \code{before_name}.
  \item \code{label_name} Same as input \code{label_name}.
  \item \code{variable_name} Same as input \code{variable_name}.
  \item \code{step_name} Same as input \code{step_name}.
  \item \code{description_name} Same as input \code{description_name}.
}
}
\description{
Calculates sequential additive variable contributions (approximate SHAP) to the prediction of a single observation, see Gosiewska and Biecek [1] and the details below.
}
\details{
The breakdown algorithm works as follows: First, the visit order (x_1, ..., x_m) of the variables \code{v} is specified. Then, in the query \code{data}, the column x_1 is set to the value of x_1 of the single observation \code{new_obs} to be explained. The change in the (weighted) average prediction on \code{data} measures the contribution of x_1 on the prediction of \code{new_obs}. This procedure is iterated over all x_i until eventually, all rows in \code{data} are identical to \code{new_obs}.
A complication with this approach is that the visit order is relevant, at least for non-additive models. Ideally, the algorithm could be repeated for all possible permutations of \code{v} and its results averaged per variable. This is basically what SHAP values do, see [1] for an explanation. Unfortunately, there is no efficient way to do this in a model agnostic way. We offer two visit strategies to approximate SHAP. The first one uses
the short-cut described in [1]: The variables are sorted by the size of their contribution in the same way as the breakdown algorithm but without iteration, i.e. starting from the original query data for each variable $x_i$. We call this visit strategy "importance". The second strategy "permutation" averages contributions from a small number of random permutations of v.
Note that the minimum required elements in the (multi-) flashlight are "y", "predict_function", "model", and "data". The latter can also directly be passed to \code{light_breakdown}. Note that by default, no retransformation function is applied.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method not implemented yet.

\item \code{flashlight}: Variable attribution to single observation for a flashlight.

\item \code{multiflashlight}: Variable attribution to single observation for a multiflashlight.
}}

\examples{
fit <- lm(Sepal.Length ~ . + Petal.Length:Species, data = iris)
fl <- flashlight(model = fit, label = "lm", data = iris, y = "Sepal.Length")
light_breakdown(fl, new_obs = iris[1, ])
}
\references{
[1] A. Gosiewska and P. Biecek (2019). IBREAKDOWN: Uncertainty of model explanations for non-additive predictive models. ArXiv <arxiv.org/abs/1903.11420>.
}
\seealso{
\code{\link{plot.light_breakdown}}.
}
